/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.util;

import gr.forth.ics.isl.xsearch.Triple;
import gr.forth.ics.isl.xsearch.util.HTMLTag;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class Util {
    public static String readSPARQLQuery(String queryPath) {
        String templ = "";
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(queryPath), "UTF8"));
            while ((line = in.readLine()) != null) {
                templ = templ + line + " ";
            }
            in.close();
        }
        catch (Exception ex) {
            System.out.println("ERROR READING TEMPLATE FILE '" + queryPath + "'\n: " + ex.getMessage());
        }
        return templ;
    }

    public static ArrayList<Triple> readSPARQLQueryResponseTriples(String response) {
        ArrayList<Triple> triples = new ArrayList<Triple>();
        HTMLTag tagger = new HTMLTag(response);
        String headStr = tagger.getFirstTagData("head");
        String resultsStr = tagger.getFirstTagData("results");
        ArrayList<String> resultsVariables = new ArrayList<String>();
        HTMLTag headTagger = new HTMLTag(headStr);
        int i = headTagger.getFirstTagIndex("variable");
        while (i != -1) {
            String variableCont = headTagger.getFirstTagContent("variable", i);
            String variable = HTMLTag.getContentAttribute((String)"name", (String)variableCont);
            resultsVariables.add(variable);
            i = headTagger.getFirstTagIndex("variable", i + 1);
        }
        HTMLTag resultsTagger = new HTMLTag(resultsStr);
        i = resultsTagger.getFirstTagIndex("result");
        while (i != -1) {
            String resultData = resultsTagger.getFirstTagData("result", i);
            HTMLTag resTagger = new HTMLTag(resultData);
            String s = "";
            String p = "";
            String o = "";
            for (String variable : resultsVariables) {
                String bindingData = resTagger.getFirstTagDataContains("binding", "\"" + variable + "\"");
                if (bindingData == null) {
                    bindingData = resTagger.getFirstTagDataContains("binding", "'" + variable + "'");
                }
                if (bindingData != null) {
                    bindingData = HTMLTag.removeTags((String)bindingData).trim();
                }
                if (variable.equals("s")) {
                    s = bindingData;
                }
                if (variable.equals("p")) {
                    p = bindingData;
                }
                if (!variable.equals("o")) continue;
                o = bindingData;
            }
            Triple triple = new Triple(s, p, o);
            triples.add(triple);
            i = resultsTagger.getFirstTagIndex("result", i + 1);
        }
        return triples;
    }

    public static String removeLinesAndMultipleSpaces(String text) {
        String newtext = text;
        while (newtext.contains("\n")) {
            newtext = newtext.replace("\n", " ");
        }
        while (newtext.contains("\r")) {
            newtext = newtext.replace("\r", " ");
        }
        while (newtext.contains("\t")) {
            newtext = newtext.replace("\t", " ");
        }
        while (newtext.contains("  ")) {
            newtext = newtext.replace("  ", " ");
        }
        newtext = newtext.trim();
        return newtext;
    }
}

