/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.api;

import gr.forth.ics.isl.xsearch.api.processdocument;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class getsupportedclusteringalgs
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParserConfigurationException, TransformerConfigurationException {
        PrintWriter out = response.getWriter();
        String format = request.getParameter("format");
        if (format == null) {
            format = "";
        }
        if (!(format = format.trim()).equals("")) {
            if (!(format.toLowerCase().equals("json") || format.toLowerCase().equals("xml") || format.toLowerCase().equals("csv"))) {
                response.sendError(400, "The value of the parameter 'format' is not valid. Valid values: {json, xml, csv}.");
                return;
            }
        } else {
            format = "json";
        }
        try {
            if (format.toLowerCase().equals("csv")) {
                response.setContentType("text/plain;charset=UTF-8");
                out.println("\"CLUSTERING_ALGORITHM_ID\"\t\"CLUSTERING_ALGORITHM_DESCRIPTION\"");
                for (String cl : Resources.SUPPORTED_CLUSTERING_ALGORITHMS.keySet()) {
                    out.println(cl + "\t" + (String)Resources.SUPPORTED_CLUSTERING_ALGORITHMS.get(cl));
                }
            } else if (format.toLowerCase().equals("xml")) {
                response.setContentType("application/xml;charset=UTF-8");
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("supportedClusteringAlgorithms");
                doc.appendChild(rootElement);
                for (String cl : Resources.SUPPORTED_CLUSTERING_ALGORITHMS.keySet()) {
                    Element alg = doc.createElement("algorithm");
                    Element id = doc.createElement("id");
                    id.appendChild(doc.createTextNode(cl));
                    Element desc = doc.createElement("description");
                    desc.appendChild(doc.createTextNode((String)Resources.SUPPORTED_CLUSTERING_ALGORITHMS.get(cl)));
                    alg.appendChild(id);
                    alg.appendChild(desc);
                    rootElement.appendChild(alg);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(out);
                try {
                    transformer.transform(source, result);
                }
                catch (TransformerException ex) {
                    Logger.getLogger(processdocument.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                response.setContentType("application/json;charset=UTF-8");
                JSONObject json = new JSONObject();
                JSONArray algs = new JSONArray();
                for (String cl : Resources.SUPPORTED_CLUSTERING_ALGORITHMS.keySet()) {
                    JSONObject alg = new JSONObject();
                    alg.put((Object)"id", (Object)cl);
                    alg.put((Object)"description", Resources.SUPPORTED_CLUSTERING_ALGORITHMS.get(cl));
                    algs.add((Object)alg);
                }
                json.put((Object)"supportedClusteringAlgorithms", (Object)algs);
                out.print(json);
                out.close();
            }
        }
        finally {
            out.close();
        }
        System.out.println("# GET SUPPORTED CLUSTERING ALGORITHMS - FINISHED!");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(getsupportedclusteringalgs.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(getsupportedclusteringalgs.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(getsupportedclusteringalgs.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(getsupportedclusteringalgs.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "Short description";
    }
}

