/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.inspecting;

import gr.forth.ics.isl.xsearch.Bean_Search;
import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.util.HTMLTag;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CheckEntityInResult
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            String element = request.getParameter("element");
            String category = request.getParameter("category");
            category = category.substring(0, category.lastIndexOf("_"));
            if (element == null) {
                out.print("<div class='em_snip'>Could not find the entity. Please try manually.</div>");
                return;
            }
            element = element.toLowerCase();
            int doc = Integer.parseInt(request.getParameter("doc"));
            HttpSession session = request.getSession();
            String query = (String)session.getAttribute("submitted_query");
            this.updateLog(request, query, element, category, doc);
            Bean_Search results = (Bean_Search)session.getAttribute("entities");
            String page_content = ((SearchResult)results.getWseResults().get(doc)).getContent();
            page_content = this.removeTags(page_content);
            ArrayList<Integer> positions = new ArrayList<Integer>();
            int index = page_content.toLowerCase().indexOf(element);
            while (index != -1) {
                positions.add(index);
                index = page_content.toLowerCase().indexOf(element, index + 1);
            }
            System.out.println("=> Occurrence: " + positions.size());
            ArrayList<String> snippets = new ArrayList<String>();
            for (int i = 0; i < positions.size(); ++i) {
                int pos = (Integer)positions.get(i);
                int start = 0;
                if (pos > 150) {
                    start = pos - 148;
                }
                int end = page_content.length() - 1;
                if (pos + 150 < page_content.length()) {
                    end = pos + 148;
                }
                if (pos < start || end < pos + element.length()) continue;
                String part1 = page_content.substring(start, pos);
                String part2 = page_content.substring(pos + element.length(), end);
                String snippet = "<div class='em_snip'>..." + part1 + "<span class='em_highlight'>" + page_content.substring(pos, pos + element.length()) + "</span>" + part2 + "...</div>";
                snippets.add(snippet);
            }
            if (!positions.isEmpty()) {
                if (snippets.isEmpty()) {
                    out.print("<div class='em_snip'>Could not find the entity '" + element + "'. Please try manually.</div>");
                } else {
                    for (String snippet : snippets) {
                        out.print(snippet);
                        out.print("<br />");
                    }
                }
            } else {
                out.print("<div class='em_snip'>Could not find the entity '" + element + "'. Please try manually.</div>");
            }
        }
    }

    public void updateLog(HttpServletRequest request, String query, String element, String category, int doc) {
        String ip = request.getRemoteAddr();
        String date = IOSLog.getCurrentDate();
        String line = "\nx-search\t" + date + "\t" + ip + "\t" + query + "\tCHECK ELEMENT '" + element + "' OF CATEGORY '" + category + "' OF DOC " + doc;
        IOSLog.writeToLog((String)line);
    }

    private String removeTags(String content) {
        String temp4;
        String temp3;
        String temp2;
        String temp1 = HTMLTag.removeTag((String)"script", (String)content);
        if (temp1 != null) {
            content = temp1;
        }
        if ((temp2 = HTMLTag.removeTag((String)"javascript", (String)content)) != null) {
            content = temp2;
        }
        if ((temp3 = HTMLTag.removeTag((String)"style", (String)content)) != null) {
            content = temp3;
        }
        if ((temp4 = HTMLTag.removeTags((String)content)) != null) {
            content = temp4;
        }
        if (content == null) {
            return "";
        }
        return content;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

