/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.helloworld.rest;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.service.helloworld.beans.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ServiceExceptionMapper
implements ExceptionMapper<Exception> {
    private final Logger logger = LoggerFactory.getLogger(ServiceExceptionMapper.class);

    public Response toResponse(Exception exception) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        String exceptionMessage = exception.getMessage();
        try {
            if (exception.getCause() != null) {
                exceptionMessage = exception.getCause().getMessage();
            }
        }
        catch (Exception e) {
            exceptionMessage = exception.getMessage();
        }
        MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
        if (WebApplicationException.class.isAssignableFrom(exception.getClass())) {
            Response gotResponse = ((WebApplicationException)exception).getResponse();
            status = Response.Status.fromStatusCode((int)gotResponse.getStatusInfo().getStatusCode());
        }
        ResponseBean responseBean = new ResponseBean();
        responseBean.setSuccess(false);
        responseBean.setMessage(exceptionMessage);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            exceptionMessage = objectMapper.writeValueAsString((Object)responseBean);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Error while serializing ResponseBean", (Throwable)e);
        }
        return Response.status((Response.Status)status).entity((Object)exceptionMessage).type(mediaType).build();
    }
}

