/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handler.resourceregistry;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRegistration;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.events.Observes;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.impl.embedded.HeaderImpl;
import org.gcube.informationsystem.impl.embedded.PropagationConstraintImpl;
import org.gcube.informationsystem.impl.embedded.ValueSchemaImpl;
import org.gcube.informationsystem.impl.entity.facet.AccessPointFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.ServiceStateFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.SoftwareFacetImpl;
import org.gcube.informationsystem.impl.entity.resource.EServiceImpl;
import org.gcube.informationsystem.impl.relation.ConsistsOfImpl;
import org.gcube.informationsystem.impl.relation.IsIdentifiedByImpl;
import org.gcube.informationsystem.impl.relation.isrelatedto.HostsImpl;
import org.gcube.informationsystem.model.embedded.PropagationConstraint;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.facet.ServiceStateFacet;
import org.gcube.informationsystem.model.entity.resource.EService;
import org.gcube.informationsystem.model.entity.resource.HostingNode;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.isrelatedto.Hosts;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="resource-management")
public class EServiceManager
extends ApplicationLifecycleHandler {
    private static final Logger logger = LoggerFactory.getLogger(EServiceManager.class);
    private ApplicationContext applicationContext;
    private AuthorizationProxy authorizationProxy = ProviderFactory.provider().authorizationProxy();
    private ScheduledFuture<?> periodicUpdates;
    private static List<String> servletExcludes = Arrays.asList("default", "jsp");

    private void setContextFromToken(String token) {
        if (token == null || token.compareTo("") == 0) {
            SecurityTokenProvider.instance.reset();
            ScopeProvider.instance.reset();
        } else {
            SecurityTokenProvider.instance.set(token);
            String scope = this.getContextName(token);
            ScopeProvider.instance.set(scope);
        }
    }

    public void onStart(ApplicationLifecycleEvent.Start e) {
        this.applicationContext = (ApplicationContext)e.context();
        this.init();
        this.registerObservers();
        this.schedulePeriodicUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
            EService eService = null;
            Set startTokens = this.applicationContext.configuration().startTokens();
            for (String token : startTokens) {
                this.setContextFromToken(token);
                if (eService != null) {
                    ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                    this.addToContext(resourceRegistryPublisher);
                }
                eService = this.getEService();
                this.share(eService);
            }
        }
        catch (Exception e) {
            Utils.rethrowUnchecked((Throwable)e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    private void share(EService eService) {
        logger.trace("sharing EService for {}", (Object)this.applicationContext.name());
        this.applicationContext.properties().add(new Property[]{new Property("EService", (Object)eService)});
    }

    private void registerObservers() {
        this.applicationContext.events().subscribe(new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"activation", "stop", "failure"})
            void onChanged(ApplicationLifecycle lc) {
                String state = EServiceManager.this.getState(lc);
                logger.debug("Moving app {} to {}", (Object)EServiceManager.this.applicationContext.name(), (Object)state);
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                if (previousToken == null) {
                    previousToken = (String)EServiceManager.this.applicationContext.configuration().startTokens().iterator().next();
                    EServiceManager.this.setContextFromToken(previousToken);
                }
                try {
                    Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
                    EServiceManager.this.createOrUpdateServiceStateFacet(state);
                }
                catch (Exception e) {
                    logger.error("Failed to update Service State", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"addToContext"})
            void addTo(String token) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                try {
                    Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
                    EServiceManager.this.setContextFromToken(token);
                    ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                    EServiceManager.this.addToContext(resourceRegistryPublisher);
                }
                catch (Exception e) {
                    logger.error("Failed to add HostingNode to current context ({})", (Object)EServiceManager.this.getCurrentContextName(), (Object)e);
                }
                finally {
                    EServiceManager.this.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"removeFromContext"})
            void removeFrom(String token) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                try {
                    Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
                    EServiceManager.this.setContextFromToken(token);
                    ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                    EServiceManager.this.removeFromContext(resourceRegistryPublisher);
                }
                catch (Exception e) {
                    logger.error("Failed to remove HostingNode from current context ({})", (Object)EServiceManager.this.getCurrentContextName(), (Object)e);
                }
                finally {
                    EServiceManager.this.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }
        });
    }

    private String getState(ApplicationLifecycle lc) {
        return ((ApplicationState)lc.state()).remoteForm().toLowerCase();
    }

    private void schedulePeriodicUpdates() {
        this.applicationContext.events().subscribe(new Object(){

            @Observes(value={"activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(final ApplicationLifecycle lc) {
                if (EServiceManager.this.periodicUpdates != null) {
                    return;
                }
                if (lc.state() == ApplicationState.active) {
                    logger.info("scheduling periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name());
                } else {
                    logger.info("resuming periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name());
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String state = EServiceManager.this.getState(lc);
                            EServiceManager.this.createOrUpdateServiceStateFacet(state);
                        }
                        catch (Exception e) {
                            logger.error("Cannot complete periodic update of EService", e);
                        }
                    }
                };
                EServiceManager.this.periodicUpdates = Utils.scheduledServicePool.scheduleAtFixedRate(updateTask, 20L, 20L, TimeUnit.MINUTES);
            }

            @Observes(value={"stop", "failure"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (EServiceManager.this.periodicUpdates != null) {
                    logger.trace("stopping periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name());
                    try {
                        EServiceManager.this.periodicUpdates.cancel(true);
                        EServiceManager.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        logger.warn("could not stop periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name(), (Object)e);
                    }
                }
            }
        });
    }

    private Hosts<HostingNode, EService> createHostsRelation(EService eService, ResourceRegistryPublisher resourceRegistryPublisher) throws ResourceRegistryException {
        HostingNode hostingNode = (HostingNode)this.applicationContext.container().properties().lookup("HostingNode").value(HostingNode.class);
        this.addToContext(resourceRegistryPublisher);
        PropagationConstraintImpl propagationConstraint = new PropagationConstraintImpl();
        propagationConstraint.setRemoveConstraint(PropagationConstraint.RemoveConstraint.cascade);
        propagationConstraint.setAddConstraint(PropagationConstraint.AddConstraint.propagate);
        Hosts<HostingNode, EService> hosts = new HostsImpl<HostingNode, EService>(hostingNode, eService, propagationConstraint);
        try {
            hosts = resourceRegistryPublisher.createIsRelatedTo(Hosts.class, hosts);
        }
        catch (ResourceNotFoundException e) {
            logger.error("THIS IS REALLY STRANGE. YOU SHOULD NE BE HERE. Error while creating {}.", (Object)hosts, (Object)e);
            throw e;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error while creating {}", (Object)hosts, (Object)e);
            throw e;
        }
        hostingNode.attachResource(hosts);
        this.shareHostingNode(hostingNode);
        return hosts;
    }

    private EService getEService() throws ResourceRegistryException {
        EService eService = null;
        ResourceRegistryClient resourceRegistryClient = ResourceRegistryClientFactory.create();
        ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
        UUID eServiceUUID = UUID.fromString(this.applicationContext.id());
        try {
            resourceRegistryClient.exists(EService.class, eServiceUUID);
            eService = resourceRegistryClient.getInstance(EService.class, eServiceUUID);
        }
        catch (ResourceNotFoundException e) {
            eService = this.instantiateEService(eServiceUUID);
            eService = (EService)this.createHostsRelation(eService, resourceRegistryPublisher).getTarget();
        }
        catch (ResourceAvailableInAnotherContextException e) {
            this.addToContext(resourceRegistryPublisher);
            eService = resourceRegistryClient.getInstance(EService.class, eServiceUUID);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        return eService;
    }

    private void shareHostingNode(HostingNode hostingNode) {
        logger.trace("sharing {} {}", (Object)"HostingNode", (Object)"Resource");
        this.applicationContext.container().properties().add(new Property[]{new Property("HostingNode", (Object)hostingNode)});
    }

    private String getCurrentContextName() {
        String token = SecurityTokenProvider.instance.get();
        return this.getContextName(token);
    }

    private String getContextName(String token) {
        try {
            return this.authorizationProxy.get(token).getContext();
        }
        catch (Exception e) {
            logger.error("Error retrieving token {}, it should never happen", (Object)token);
            return null;
        }
    }

    private void addToContext(ResourceRegistryPublisher resourceRegistryPublisher) throws ResourceRegistryException {
        HostingNode hostingNode = (HostingNode)this.applicationContext.container().properties().lookup("HostingNode").value(HostingNode.class);
        resourceRegistryPublisher.addResourceToContext(hostingNode);
        logger.info("{} successfully added to current context ({})", (Object)hostingNode, (Object)this.getCurrentContextName());
        this.shareHostingNode(hostingNode);
    }

    private void removeFromContext(ResourceRegistryPublisher resourceRegistryPublisher) throws ResourceRegistryException {
        HostingNode hostingNode = (HostingNode)this.applicationContext.container().properties().lookup("HostingNode").value(HostingNode.class);
        resourceRegistryPublisher.removeResourceFromContext(hostingNode);
        logger.info("{} successfully removed from current context ({})", (Object)hostingNode, (Object)this.getCurrentContextName());
        this.shareHostingNode(hostingNode);
    }

    private void createOrUpdateServiceStateFacet(String state) throws ResourceRegistryException {
        ResourceRegistryClient resourceRegistryClient = ResourceRegistryClientFactory.create();
        ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
        EService eService = this.getEService();
        ServiceStateFacet serviceStateFacet = null;
        List<ServiceStateFacet> serviceStateFacets = eService.getFacets(ServiceStateFacet.class);
        if (serviceStateFacets != null && serviceStateFacets.size() >= 1) {
            serviceStateFacet = serviceStateFacets.get(0);
            serviceStateFacet.setValue(state);
            serviceStateFacet = resourceRegistryPublisher.updateFacet(ServiceStateFacet.class, serviceStateFacet);
            for (int i = 1; i < serviceStateFacets.size(); ++i) {
                try {
                    logger.warn("You should not be here. There are more than one {}. Anyway deleting it : {}", (Object)ServiceStateFacet.class.getSimpleName(), (Object)serviceStateFacets.get(i));
                    resourceRegistryPublisher.deleteFacet((Facet)serviceStateFacets.get(i));
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Unable to delete {}  which should not exists : {}", (Object)ServiceStateFacet.class.getSimpleName(), (Object)serviceStateFacets.get(i));
                }
            }
        } else {
            serviceStateFacet = new ServiceStateFacetImpl();
            serviceStateFacet.setValue(state);
            serviceStateFacet = resourceRegistryPublisher.createFacet(ServiceStateFacet.class, serviceStateFacet);
            ConsistsOfImpl<EService, ServiceStateFacet> consistsOf = new ConsistsOfImpl<EService, ServiceStateFacet>(eService, serviceStateFacet, null);
            consistsOf = resourceRegistryPublisher.createConsistsOf(ConsistsOf.class, consistsOf);
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            String previousToken = SecurityTokenProvider.instance.get();
            try {
                Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
                Set startTokens = this.applicationContext.configuration().startTokens();
                for (String token : startTokens) {
                    this.setContextFromToken(token);
                    this.addToContext(resourceRegistryPublisher);
                }
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            finally {
                this.setContextFromToken(previousToken);
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }
        UUID eServiceUUID = eService.getHeader().getUUID();
        eService = resourceRegistryClient.getInstance(EService.class, eServiceUUID);
        this.share(eService);
    }

    private static String getBaseAddress(ApplicationContext context) {
        String baseAddress;
        ApplicationConfiguration configuration = context.configuration();
        ContainerConfiguration container = context.container().configuration();
        if (configuration.proxied()) {
            String protocol = container.proxyAddress().secure() ? "https://" : "http://";
            int port = container.proxyAddress().port();
            baseAddress = String.format("%s%s:%d%s", protocol, container.proxyAddress().hostname(), port, context.application().getContextPath());
        } else {
            String protocol = configuration.secure() ? "https://" : "http://";
            int port = configuration.secure() ? container.securePort().intValue() : container.port();
            baseAddress = String.format("%s%s:%d%s", protocol, container.hostname(), port, context.application().getContextPath());
        }
        return baseAddress;
    }

    private EService instantiateEService(UUID uuid) {
        logger.info("Creating EService for {}", (Object)this.applicationContext.name());
        ApplicationConfiguration applicationConfiguration = this.applicationContext.configuration();
        EServiceImpl eService = new EServiceImpl();
        HeaderImpl header = new HeaderImpl(uuid);
        eService.setHeader(header);
        SoftwareFacetImpl softwareFacet = new SoftwareFacetImpl();
        softwareFacet.setDescription(applicationConfiguration.description());
        softwareFacet.setGroup(applicationConfiguration.serviceClass());
        softwareFacet.setName(applicationConfiguration.name());
        softwareFacet.setVersion(applicationConfiguration.version());
        IsIdentifiedByImpl<EServiceImpl, SoftwareFacetImpl> isIdentifiedBy = new IsIdentifiedByImpl<EServiceImpl, SoftwareFacetImpl>(eService, softwareFacet, null);
        eService.addFacet(isIdentifiedBy);
        String baseAddress = EServiceManager.getBaseAddress(this.applicationContext);
        for (ServletRegistration servlet : this.applicationContext.application().getServletRegistrations().values()) {
            if (servletExcludes.contains(servlet.getName())) continue;
            for (String mapping : servlet.getMappings()) {
                String address = baseAddress + (mapping.endsWith("*") ? mapping.substring(0, mapping.length() - 2) : mapping);
                AccessPointFacetImpl accessPointFacet = new AccessPointFacetImpl();
                accessPointFacet.setEntryName(servlet.getName());
                accessPointFacet.setEndpoint(URI.create(address));
                ValueSchemaImpl valueSchema = new ValueSchemaImpl();
                valueSchema.setValue("gcube-token");
                accessPointFacet.setAuthorization(valueSchema);
                eService.addFacet(accessPointFacet);
            }
        }
        ServiceStateFacetImpl serviceStateFacet = new ServiceStateFacetImpl();
        String state = this.getState(this.applicationContext.lifecycle());
        serviceStateFacet.setValue(state.toLowerCase());
        eService.addFacet(serviceStateFacet);
        return eService;
    }

    public String toString() {
        return "resource-management";
    }
}

