/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handler.resourceregistry.resourcemanager;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletRegistration;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.resourcemanagement.model.impl.entities.facets.AccessPointFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.ServiceStateFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.EServiceImpl;
import org.gcube.resourcemanagement.model.impl.properties.ValueSchemaImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.IsIdentifiedByImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.ActivatesImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ServiceStateFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.entities.resources.HostingNode;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Activates;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handler.resourceregistry.Constants;
import org.gcube.smartgears.handler.resourceregistry.ContextUtility;
import org.gcube.smartgears.handler.resourceregistry.resourcemanager.HostingNodeManager;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EServiceManager {
    private static Logger logger = LoggerFactory.getLogger(HostingNodeManager.class);
    private static List<String> servletExcludes = Arrays.asList("default", "jsp");
    private ResourceRegistryPublisher resourceRegistryPublisher;
    private EService eService;
    private ServiceStateFacet serviceStateFacet;
    private ApplicationContext applicationContext;

    public EServiceManager(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
    }

    public EService getEService() {
        return this.eService;
    }

    public void addToContext() throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        HostingNode hostingNode = ((HostingNodeManager)this.applicationContext.container().properties().lookup(Constants.HOSTING_NODE_MANAGER_PROPERTY).value(HostingNodeManager.class)).getHostingNode();
        boolean added = this.resourceRegistryPublisher.addResourceToCurrentContext((Resource)hostingNode);
        if (added) {
            logger.info("{} successfully added to current context ({})", (Object)this.eService, (Object)ContextUtility.getCurrentContextName());
        } else {
            logger.error("Unable to add {} to current context ({})", (Object)this.eService, (Object)ContextUtility.getCurrentContextName());
        }
    }

    public void removeFromContext() throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        boolean removed = false;
        removed = this.resourceRegistryPublisher.removeResourceFromCurrentContext((Resource)this.eService);
        if (removed) {
            logger.info("{} successfully removed from current context ({})", (Object)this.eService, (Object)ContextUtility.getCurrentContextName());
        } else {
            logger.error("Unable to remove {} from current context ({})", (Object)this.eService, (Object)ContextUtility.getCurrentContextName());
        }
    }

    public void removeFromContext(UUID contextUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        boolean removed = false;
        String contextFullName = ContextCache.getInstance().getContextFullNameByUUID(contextUUID);
        removed = this.resourceRegistryPublisher.removeResourceFromContext((Resource)this.eService, contextUUID);
        if (removed) {
            logger.info("{} successfully removed from context ({})", (Object)this.eService, (Object)contextFullName);
        } else {
            logger.error("Unable to remove {} from current context ({})", (Object)this.eService, (Object)contextFullName);
        }
    }

    private String getBaseAddress() {
        String baseAddress;
        ApplicationConfiguration configuration = this.applicationContext.configuration();
        ContainerConfiguration container = this.applicationContext.container().configuration();
        if (configuration.proxied()) {
            String protocol = configuration.proxyAddress().protocol();
            String port = configuration.proxyAddress().port() != null ? ":" + configuration.proxyAddress().port() : "";
            baseAddress = String.format("%s://%s%s%s", protocol, configuration.proxyAddress().hostname(), port, this.applicationContext.application().getContextPath());
        } else {
            String protocol = container.protocol();
            int port = container.port();
            baseAddress = String.format("%s://%s:%d%s", protocol, container.hostname(), port, this.applicationContext.application().getContextPath());
        }
        return baseAddress;
    }

    public String getState() {
        return ((ApplicationState)this.applicationContext.lifecycle().state()).remoteForm().toLowerCase();
    }

    private EService instantiateEService() {
        logger.info("Creating {} for {}", (Object)"EService", (Object)this.applicationContext.name());
        ApplicationConfiguration applicationConfiguration = this.applicationContext.configuration();
        String id = this.applicationContext.id();
        UUID uuid = UUID.fromString(id);
        EServiceImpl eService = new EServiceImpl();
        HeaderImpl header = new HeaderImpl(uuid);
        eService.setHeader((Header)header);
        SoftwareFacetImpl softwareFacet = new SoftwareFacetImpl();
        softwareFacet.setDescription(applicationConfiguration.description());
        softwareFacet.setGroup(applicationConfiguration.serviceClass());
        softwareFacet.setName(applicationConfiguration.name());
        softwareFacet.setVersion(applicationConfiguration.version());
        IsIdentifiedByImpl isIdentifiedBy = new IsIdentifiedByImpl((Resource)eService, (Facet)softwareFacet);
        eService.addFacet((ConsistsOf)isIdentifiedBy);
        String baseAddress = this.getBaseAddress();
        for (ServletRegistration servlet : this.applicationContext.application().getServletRegistrations().values()) {
            if (servletExcludes.contains(servlet.getName())) continue;
            for (String mapping : servlet.getMappings()) {
                String address = baseAddress + (mapping.endsWith("*") ? mapping.substring(0, mapping.length() - 2) : mapping);
                AccessPointFacetImpl accessPointFacet = new AccessPointFacetImpl();
                accessPointFacet.setEntryName(servlet.getName());
                accessPointFacet.setEndpoint(URI.create(address));
                ValueSchemaImpl valueSchema = new ValueSchemaImpl();
                valueSchema.setValue("gcube-token");
                accessPointFacet.setAuthorization((Property)valueSchema);
                eService.addFacet((Facet)accessPointFacet);
            }
        }
        this.serviceStateFacet = new ServiceStateFacetImpl();
        String state = this.getState();
        this.serviceStateFacet.setValue(state);
        eService.addFacet((Facet)this.serviceStateFacet);
        return eService;
    }

    public EService createEService() throws ResourceRegistryException {
        ResourceRegistryClient resourceRegistryClient = ResourceRegistryClientFactory.create();
        UUID eServiceUUID = UUID.fromString(this.applicationContext.id());
        try {
            ResourceRegistryClientFactory.includeContextsInInstanceHeader((boolean)true);
            this.eService = (EService)resourceRegistryClient.getInstance(EService.class, eServiceUUID);
            this.serviceStateFacet = (ServiceStateFacet)this.eService.getFacets(ServiceStateFacet.class).get(0);
            if (this.serviceStateFacet == null) {
                this.serviceStateFacet = new ServiceStateFacetImpl();
                String state = this.getState();
                this.serviceStateFacet.setValue(state);
                this.eService.addFacet((Facet)this.serviceStateFacet);
                this.resourceRegistryPublisher.update((IdentifiableElement)this.eService);
            } else {
                this.updateServiceStateFacet();
            }
        }
        catch (NotFoundException e) {
            this.eService = this.instantiateEService();
            this.createActivatesRelation(this.eService);
        }
        catch (AvailableInAnotherContextException e) {
            this.addToContext();
            try {
                this.eService = (EService)resourceRegistryClient.getInstance(EService.class, eServiceUUID);
            }
            catch (AvailableInAnotherContextException ex) {
                this.resourceRegistryPublisher.addResourceToCurrentContext((Resource)this.eService);
                this.createActivatesRelation(this.eService);
            }
            this.serviceStateFacet = (ServiceStateFacet)this.eService.getFacets(ServiceStateFacet.class).get(0);
            if (this.serviceStateFacet == null) {
                this.serviceStateFacet = new ServiceStateFacetImpl();
                String state = this.getState();
                this.serviceStateFacet.setValue(state);
                this.eService.addFacet((Facet)this.serviceStateFacet);
                this.resourceRegistryPublisher.update((IdentifiableElement)this.eService);
            } else {
                this.updateServiceStateFacet();
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        return this.eService;
    }

    public void updateServiceStateFacet() throws ResourceRegistryException {
        String state = this.getState();
        this.serviceStateFacet.setValue(state);
        this.serviceStateFacet = (ServiceStateFacet)this.resourceRegistryPublisher.updateFacet((Facet)this.serviceStateFacet);
    }

    private Activates<HostingNode, EService> createActivatesRelation(EService eService) throws ResourceRegistryException {
        HostingNode hostingNode = ((HostingNodeManager)this.applicationContext.container().properties().lookup(Constants.HOSTING_NODE_MANAGER_PROPERTY).value(HostingNodeManager.class)).getHostingNode();
        PropagationConstraintImpl propagationConstraint = new PropagationConstraintImpl();
        propagationConstraint.setRemoveConstraint(PropagationConstraint.RemoveConstraint.cascade);
        propagationConstraint.setAddConstraint(PropagationConstraint.AddConstraint.propagate);
        ActivatesImpl activates = new ActivatesImpl((Service)hostingNode, (Service)eService, (PropagationConstraint)propagationConstraint);
        try {
            activates = (Activates)this.resourceRegistryPublisher.createIsRelatedTo((IsRelatedTo)activates);
        }
        catch (NotFoundException e) {
            logger.error("THIS IS REALLY STRANGE. YOU SHOULD NE BE HERE. Error while creating {}.", (Object)activates, (Object)e);
            throw e;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error while creating {}", (Object)activates, (Object)e);
            throw e;
        }
        hostingNode.attachResource((IsRelatedTo)activates);
        return activates;
    }

    public void removeEService() throws ResourceRegistryException {
        try {
            this.resourceRegistryPublisher.delete((IdentifiableElement)this.eService);
        }
        catch (ResourceRegistryException e) {
            logger.error("Unable to delete {}. Going to set the state to {}", (Object)this.applicationContext.name(), (Object)this.getState());
            this.updateServiceStateFacet();
        }
    }

    public Set<UUID> getContextsUUID() throws Exception {
        return this.resourceRegistryPublisher.getResourceContexts((Resource)this.eService);
    }
}

