/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handler.resourceregistry.resourcemanager;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletRegistration;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.resourcemanagement.model.impl.entities.facets.AccessPointFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.EventFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.StateFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.EServiceImpl;
import org.gcube.resourcemanagement.model.impl.properties.ValueSchemaImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.IsIdentifiedByImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.ActivatesImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.EventFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.StateFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.entities.resources.HostingNode;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Activates;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handler.resourceregistry.Constants;
import org.gcube.smartgears.handler.resourceregistry.ContextUtility;
import org.gcube.smartgears.handler.resourceregistry.resourcemanager.HostingNodeManager;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EServiceManager {
    private static Logger logger = LoggerFactory.getLogger(HostingNodeManager.class);
    private static List<String> servletExcludes = Arrays.asList("default", "jsp");
    private ResourceRegistryPublisher resourceRegistryPublisher;
    private EService eService;
    private ApplicationContext applicationContext;

    public EServiceManager(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEServiceToCurrentContext() throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String currentToken = SecurityTokenProvider.instance.get();
        UUID contextUUID = ContextUtility.getContextUUID(currentToken);
        boolean anotherContextSet = false;
        Set startTokens = this.applicationContext.configuration().startTokens();
        for (String token : startTokens) {
            UUID anotherContextUUID = ContextUtility.getContextUUID(token);
            if (anotherContextUUID.compareTo(contextUUID) == 0) continue;
            ContextUtility.setContextFromToken(token);
            anotherContextSet = true;
            break;
        }
        UUID uuid = UUID.fromString(this.applicationContext.id());
        try {
            if (anotherContextSet) {
                this.resourceRegistryPublisher.addResourceToContext("EService", uuid, contextUUID, Boolean.valueOf(false));
            } else {
                this.resourceRegistryPublisher.addResourceToCurrentContext("HostingNode", uuid, Boolean.valueOf(false));
            }
            logger.info("{} with UUID {} successfully added to context ({})", new Object[]{"EService", uuid, ContextUtility.getCurrentContextName()});
        }
        catch (Exception e) {
            logger.error("Unable to add {} with UUID {} to context ({})", new Object[]{"EService", uuid, ContextUtility.getCurrentContextName(), e});
        }
        finally {
            ContextUtility.setContextFromToken(currentToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostingNodeToCurrentContext() throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String currentToken = SecurityTokenProvider.instance.get();
        UUID contextUUID = ContextUtility.getContextUUID(currentToken);
        boolean anotherContextSet = false;
        Set startTokens = this.applicationContext.configuration().startTokens();
        for (String token : startTokens) {
            UUID anotherContextUUID = ContextUtility.getContextUUID(token);
            if (anotherContextUUID.compareTo(contextUUID) == 0) continue;
            ContextUtility.setContextFromToken(token);
            anotherContextSet = true;
            break;
        }
        UUID uuid = UUID.fromString(this.applicationContext.container().id());
        try {
            if (anotherContextSet) {
                this.resourceRegistryPublisher.addResourceToContext("HostingNode", uuid, contextUUID, Boolean.valueOf(false));
            } else {
                this.resourceRegistryPublisher.addResourceToCurrentContext("HostingNode", uuid, Boolean.valueOf(false));
            }
            logger.info("{} with UUID {} successfully added to context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getCurrentContextName()});
        }
        catch (Exception e) {
            logger.error("Unable to add {} with UUID {} to context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getCurrentContextName(), e});
        }
        finally {
            ContextUtility.setContextFromToken(currentToken);
        }
    }

    public void addToContext(UUID contextUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID uuid = UUID.fromString(this.applicationContext.container().id());
        try {
            this.resourceRegistryPublisher.addToContext("HostingNode", uuid, contextUUID, Boolean.valueOf(false));
            logger.info("{} with UUID {} successfully added to context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getContextNameFromUUID(contextUUID)});
        }
        catch (Exception e) {
            logger.error("Unable to add {} with UUID {} to context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getContextNameFromUUID(contextUUID), e});
        }
    }

    public void removeFromCurrentContext() throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID uuid = UUID.fromString(this.applicationContext.container().id());
        try {
            this.resourceRegistryPublisher.removeResourceFromCurrentContext("HostingNode", uuid, Boolean.valueOf(false));
            logger.info("{} with UUID {} successfully removed from context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getCurrentContextName()});
        }
        catch (Exception e) {
            logger.error("Unable to remove {} with UUID {} from context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getCurrentContextName(), e});
        }
    }

    public void removeFromContext(UUID contextUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String contextFullName = ContextUtility.getContextNameFromUUID(contextUUID);
        UUID uuid = UUID.fromString(this.applicationContext.container().id());
        try {
            this.resourceRegistryPublisher.removeResourceFromContext("HostingNode", uuid, contextUUID, Boolean.valueOf(false));
            logger.info("{} with UUID {} successfully removed from context ({})", new Object[]{"HostingNode", uuid, contextFullName});
        }
        catch (Exception e) {
            logger.error("Unable to remove {} from context ({})", new Object[]{"HostingNode", uuid, contextFullName, e});
        }
    }

    private String getBaseAddress() {
        String baseAddress;
        ApplicationConfiguration configuration = this.applicationContext.configuration();
        ContainerConfiguration container = this.applicationContext.container().configuration();
        if (configuration.proxied()) {
            String protocol = configuration.proxyAddress().protocol();
            String port = configuration.proxyAddress().port() != null ? ":" + configuration.proxyAddress().port() : "";
            baseAddress = String.format("%s://%s%s%s", protocol, configuration.proxyAddress().hostname(), port, this.applicationContext.application().getContextPath());
        } else {
            String protocol = container.protocol();
            int port = container.port();
            baseAddress = String.format("%s://%s:%d%s", protocol, container.hostname(), port, this.applicationContext.application().getContextPath());
        }
        return baseAddress;
    }

    public String getState() {
        return ((ApplicationState)this.applicationContext.lifecycle().state()).remoteForm().toLowerCase();
    }

    private StateFacet getStateFacet(StateFacet stateFacet, Date date) {
        if (stateFacet == null) {
            stateFacet = new StateFacetImpl();
        }
        String state = this.getState();
        stateFacet.setValue(state);
        stateFacet.setAdditionalProperty("date", (Object)date);
        return stateFacet;
    }

    private EventFacet getEventFacet(Date date) {
        EventFacetImpl eventFacet = new EventFacetImpl();
        eventFacet.setDate(date);
        String state = this.getState();
        eventFacet.setEvent(state);
        return eventFacet;
    }

    private EService instantiateEService() {
        logger.info("Creating {} for {}", (Object)"EService", (Object)this.applicationContext.name());
        ApplicationConfiguration applicationConfiguration = this.applicationContext.configuration();
        String id = this.applicationContext.id();
        UUID uuid = UUID.fromString(id);
        EServiceImpl eService = new EServiceImpl();
        HeaderImpl header = new HeaderImpl(uuid);
        eService.setHeader((Header)header);
        SoftwareFacetImpl softwareFacet = new SoftwareFacetImpl();
        softwareFacet.setDescription(applicationConfiguration.description());
        softwareFacet.setGroup(applicationConfiguration.serviceClass());
        softwareFacet.setName(applicationConfiguration.name());
        softwareFacet.setVersion(applicationConfiguration.version());
        IsIdentifiedByImpl isIdentifiedBy = new IsIdentifiedByImpl((Resource)eService, (Facet)softwareFacet);
        eService.addFacet((ConsistsOf)isIdentifiedBy);
        String baseAddress = this.getBaseAddress();
        for (ServletRegistration servlet : this.applicationContext.application().getServletRegistrations().values()) {
            if (servletExcludes.contains(servlet.getName())) continue;
            for (String mapping : servlet.getMappings()) {
                String address = baseAddress + (mapping.endsWith("*") ? mapping.substring(0, mapping.length() - 2) : mapping);
                AccessPointFacetImpl accessPointFacet = new AccessPointFacetImpl();
                accessPointFacet.setEntryName(servlet.getName());
                accessPointFacet.setEndpoint(URI.create(address));
                ValueSchemaImpl valueSchema = new ValueSchemaImpl();
                valueSchema.setValue("gcube-token");
                accessPointFacet.setAuthorization((Property)valueSchema);
                eService.addFacet((Facet)accessPointFacet);
            }
        }
        Date date = Calendar.getInstance().getTime();
        StateFacet stateFacet = this.getStateFacet(null, date);
        eService.addFacet((Facet)stateFacet);
        EventFacet eventFacet = this.getEventFacet(date);
        eService.addFacet((Facet)eventFacet);
        return eService;
    }

    public EService createEService() throws ResourceRegistryException {
        ResourceRegistryClient resourceRegistryClient = ResourceRegistryClientFactory.create();
        UUID eServiceUUID = UUID.fromString(this.applicationContext.id());
        try {
            this.eService = (EService)resourceRegistryClient.getInstance(EService.class, eServiceUUID);
            this.updateFacets();
        }
        catch (NotFoundException e) {
            this.eService = this.instantiateEService();
            this.eService = (EService)this.createActivatesRelation(this.eService).getTarget();
        }
        catch (AvailableInAnotherContextException e) {
            this.addHostingNodeToCurrentContext();
            try {
                this.eService = (EService)resourceRegistryClient.getInstance(EService.class, eServiceUUID);
            }
            catch (AvailableInAnotherContextException ex) {
                this.addEServiceToCurrentContext();
                this.eService = (EService)resourceRegistryClient.getInstance(EService.class, eServiceUUID);
                this.eService = (EService)this.createActivatesRelation(this.eService).getTarget();
            }
            this.updateFacets();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        return this.eService;
    }

    public EService updateFacets() throws ResourceRegistryException {
        logger.debug("Updating {} for {}", (Object)"EService", (Object)this.applicationContext.configuration().name());
        StateFacet stateFacet = null;
        EventFacet eventFacet = null;
        Date date = Calendar.getInstance().getTime();
        ArrayList<ConsistsOf> consistsOfToRemove = new ArrayList<ConsistsOf>();
        List consistsOfList = this.eService.getConsistsOf();
        for (ConsistsOf c : consistsOfList) {
            if (c.getTarget() instanceof StateFacet) {
                stateFacet = (StateFacet)c.getTarget();
                stateFacet = this.getStateFacet(stateFacet, date);
                continue;
            }
            if (c.getTarget() instanceof EventFacet) {
                eventFacet = (EventFacet)c.getTarget();
                String value = eventFacet.getEvent();
                if (value.compareTo(this.getState()) == 0) {
                    eventFacet.setDate(date);
                    continue;
                }
                eventFacet = null;
            }
            consistsOfToRemove.add(c);
        }
        consistsOfList.removeAll(consistsOfToRemove);
        if (eventFacet == null) {
            eventFacet = this.getEventFacet(date);
            this.eService.addFacet((Facet)eventFacet);
        }
        try {
            logger.trace("Updating {} for {} : {}", new Object[]{"EService", this.applicationContext.configuration().name(), ElementMapper.marshal((Element)this.eService)});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eService = (EService)this.resourceRegistryPublisher.updateResource((Resource)this.eService);
        }
        catch (ResourceRegistryException e) {
            logger.error("Error trying to publish hosting node", (Throwable)e);
        }
        return this.eService;
    }

    private Activates<HostingNode, EService> createActivatesRelation(EService eService) throws ResourceRegistryException {
        HostingNode hostingNode = ((HostingNodeManager)this.applicationContext.container().properties().lookup(Constants.HOSTING_NODE_MANAGER_PROPERTY).value()).getHostingNode();
        PropagationConstraintImpl propagationConstraint = new PropagationConstraintImpl();
        propagationConstraint.setRemoveConstraint(PropagationConstraint.RemoveConstraint.cascade);
        propagationConstraint.setAddConstraint(PropagationConstraint.AddConstraint.propagate);
        ActivatesImpl activates = new ActivatesImpl((Service)hostingNode, (Service)eService, (PropagationConstraint)propagationConstraint);
        try {
            logger.trace("Going to create {} and {} for application {} : {}", new Object[]{"Activates", "EService", this.applicationContext.configuration().name(), ElementMapper.marshal((Element)activates)});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            activates = (Activates)this.resourceRegistryPublisher.createIsRelatedTo((IsRelatedTo)activates);
            hostingNode.attachResource((IsRelatedTo)activates);
        }
        catch (NotFoundException e) {
            logger.error("THIS IS REALLY STRANGE. YOU SHOULD NOT BE HERE. Error while creating {}.", (Object)activates, (Object)e);
            throw e;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error while creating {}", (Object)activates, (Object)e);
            throw e;
        }
        return activates;
    }

    public Map<UUID, String> getContextsUUID() throws Exception {
        return this.resourceRegistryPublisher.getResourceContexts((Resource)this.eService);
    }
}

