/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.social_networking_client_library;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang.Validate;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.social_networking.social_networking_client_library.BaseClient;
import org.gcube.social_networking.social_networking_client_library.utils.HttpClient;
import org.gcube.social_networking.socialnetworking.model.beans.PostInputBean;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostClient
extends BaseClient {
    private static final String SUB_SERVICE_PATH = "2/posts/";
    private static Logger logger = LoggerFactory.getLogger(PostClient.class);

    public PostClient() throws Exception {
        super(SUB_SERVICE_PATH);
    }

    public List<Feed> getUserPostsSinceDate(long timeInMillis) {
        Validate.isTrue((timeInMillis >= 0L ? 1 : 0) != 0, (String)"time cannot be negative");
        logger.debug("Request for getting posts");
        String thisMethodSignature = "get-posts-user-since";
        String request = this.getServiceEndpoint() + thisMethodSignature + "?time=" + timeInMillis;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Feed>>>(){}, request);
    }

    public List<Feed> getAllUserPosts() {
        logger.debug("Request for getting posts");
        String thisMethodSignature = "get-posts-user";
        String request = this.getServiceEndpoint() + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Feed>>>(){}, request);
    }

    public List<Feed> getUserPostsQuantity(int quantity) {
        Validate.isTrue((quantity >= 0 ? 1 : 0) != 0, (String)"quantity cannot be negative");
        logger.debug("Request for getting posts");
        String thisMethodSignature = "get-posts-user-quantity";
        String request = this.getServiceEndpoint() + thisMethodSignature + "?quantity=" + quantity;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Feed>>>(){}, request);
    }

    public Feed writeUserPost(PostInputBean toWrite) {
        Validate.isTrue((toWrite != null ? 1 : 0) != 0, (String)"Post to write cannot be null");
        logger.debug("Request for writing post");
        String thisMethodSignature = "write-post-user";
        String request = this.getServiceEndpoint() + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<Feed>>(){}, request, toWrite);
    }

    public List<Feed> getAllApplicationPosts() {
        logger.debug("Request for getting posts");
        String thisMethodSignature = "get-posts-app";
        String request = this.getServiceEndpoint() + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Feed>>>(){}, request);
    }

    public Feed writeApplicationPost(PostInputBean toWrite) {
        Validate.isTrue((toWrite != null ? 1 : 0) != 0, (String)"Post to write cannot be null");
        logger.debug("Request for writing application post");
        String thisMethodSignature = "write-post-app";
        String request = this.getServiceEndpoint() + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<Feed>>(){}, request, toWrite);
    }

    public List<Feed> getPostsVRE() {
        logger.debug("Request for getting posts vre");
        String thisMethodSignature = "get-posts-vre";
        String request = this.getServiceEndpoint() + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Feed>>>(){}, request);
    }

    public List<Feed> getHashtagPosts(String hashtag) throws UnsupportedEncodingException {
        Validate.isTrue((hashtag != null ? 1 : 0) != 0, (String)"hashtag cannot be null");
        logger.debug("Request for getting posts with hashtag " + hashtag);
        String thisMethodSignature = "get-posts-by-hashtag";
        String request = this.getServiceEndpoint() + thisMethodSignature + "?hashtag=" + URLEncoder.encode(hashtag, "UTF-8");
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Feed>>>(){}, request);
    }

    public List<Feed> getUserLikedPost() {
        logger.debug("Request for getting posts liked");
        String thisMethodSignature = "get-liked-posts";
        String request = this.getServiceEndpoint() + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Feed>>>(){}, request);
    }

    public List<String> getUserLikedPostIds() {
        logger.debug("Request for getting posts liked");
        String thisMethodSignature = "get-id-liked-posts";
        String request = this.getServiceEndpoint() + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<String>>>(){}, request);
    }
}

