/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social_networking_client_library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.shared.EnhancedFeed;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.Post;
import org.gcube.social_networking.social_networking_client_library.FullTextSearchClient;
import org.gcube.social_networking.social_networking_client_library.HashTagClient;
import org.gcube.social_networking.social_networking_client_library.MessageClient;
import org.gcube.social_networking.social_networking_client_library.NotificationClient;
import org.gcube.social_networking.social_networking_client_library.PeopleClient;
import org.gcube.social_networking.social_networking_client_library.PostClient;
import org.gcube.social_networking.social_networking_client_library.TokenClient;
import org.gcube.social_networking.social_networking_client_library.UserClient;
import org.gcube.social_networking.social_networking_client_library.VREClient;
import org.gcube.social_networking.socialnetworking.model.beans.ApplicationId;
import org.gcube.social_networking.socialnetworking.model.beans.JobNotificationBean;
import org.gcube.social_networking.socialnetworking.model.beans.JobStatusModelType;
import org.gcube.social_networking.socialnetworking.model.beans.MessageInbox;
import org.gcube.social_networking.socialnetworking.model.beans.MessageInputBean;
import org.gcube.social_networking.socialnetworking.model.beans.PostInputBean;
import org.gcube.social_networking.socialnetworking.model.beans.Recipient;
import org.gcube.social_networking.socialnetworking.model.beans.UserProfile;
import org.gcube.social_networking.socialnetworking.model.beans.UserProfileExtended;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEvent;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEventType;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.AddedItemEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.DeletedItemEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.FileItemBean;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.FolderBean;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.UpdatedItemEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.WorkspaceEvent;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClientServices {
    private static Logger logger = LoggerFactory.getLogger(TestClientServices.class);

    @Before
    public void setContextAndToken() {
        ScopeProvider.instance.set("/gcube/devsec/devVRE");
        String umaToken = "eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICJSSklZNEpoNF9qdDdvNmREY0NlUDFfS1l0akcxVExXVW9oMkQ2Tzk1bFNBIn0.eyJleHAiOjE2NjYyODUxMDYsImlhdCI6MTY2NjI4NDgwNiwiYXV0aF90aW1lIjoxNjY2Mjc5NDM2LCJqdGkiOiJjYjlmZDgxNi1kNGU5LTQ4NTYtOTQ5My1iYzk4ZDFhYTdiZTMiLCJpc3MiOiJodHRwczovL2FjY291bnRzLmRldi5kNHNjaWVuY2Uub3JnL2F1dGgvcmVhbG1zL2Q0c2NpZW5jZSIsImF1ZCI6IiUyRmdjdWJlJTJGZGV2c2VjJTJGZGV2VlJFIiwic3ViIjoiNzcxZjYxNTEtMDBhZS00NWMyLWE3NTQtZjA1NDZkOThmNDgyIiwidHlwIjoiQmVhcmVyIiwiYXpwIjoibmV4dC5kNHNjaWVuY2Uub3JnIiwic2Vzc2lvbl9zdGF0ZSI6ImNlZDM0NmE1LWExNzctNGNmYy1iYjU5LTBlMjk5OWJhZDU4ZCIsImFsbG93ZWQtb3JpZ2lucyI6WyIvKiJdLCJyZXNvdXJjZV9hY2Nlc3MiOnsiJTJGZ2N1YmUlMkZkZXZzZWMlMkZkZXZWUkUiOnsicm9sZXMiOlsiQ2F0YWxvZ3VlLU1hbmFnZXIiLCJNZW1iZXIiXX19LCJhdXRob3JpemF0aW9uIjp7InBlcm1pc3Npb25zIjpbeyJyc2lkIjoiNTcyODU1MTAtMzkzOS00ZGU3LThmYzEtZTNhOWQzY2NlMjgxIiwicnNuYW1lIjoiRGVmYXVsdCBSZXNvdXJjZSJ9XX0sInNjb3BlIjoiZW1haWwgcHJvZmlsZSIsInNpZCI6ImNlZDM0NmE1LWExNzctNGNmYy1iYjU5LTBlMjk5OWJhZDU4ZCIsImVtYWlsX3ZlcmlmaWVkIjp0cnVlLCJuYW1lIjoiQW5kcmVhIFJvc3NpIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYW5kcmVhLnJvc3NpIiwiZ2l2ZW5fbmFtZSI6IkFuZHJlYSIsImZhbWlseV9uYW1lIjoiUm9zc2kiLCJlbWFpbCI6Im0uYXNzYW50ZUBnbWFpbC5jb20ifQ.HHHqPWPkq8wVV2dT8U4iraGy0VpdFb2MJKTGZLz3woqhGOo7cARKTF9S_Cv9RigkL7vg_vriScDZzwCH-jVopK8EDRZTthiQIITzYG7EPg-B0zuOkUeC1GE0LFU3kqCTpwbLElOmQJfn6FP95lzMQWIhJrMSwVwjsXDf12bcYyr0QZDa8A9lxA4RkQezkpXhJ72s841oOp1vul5wyoSFYCdr7cZnMLuY5pdasheqGfQdkGi39SZ_dlnGgAkEArVqUCIlCxvdT2EUpiPG9854e2fBFdOss6NiSbZHF5n5nLvR8kDCaN12YOCw54fxwAByhvI0pBKEa_uM029eip43-A";
        AccessTokenProvider.instance.set(umaToken);
        SecurityTokenProvider.instance.set("");
    }

    @Test
    public void testCatalogueEvents() throws Exception {
        NotificationClient nc = new NotificationClient();
        String[] idstoNotify = new String[]{"andrea.rossi"};
        CatalogueEvent event = new CatalogueEvent(CatalogueEventType.ITEM_SUBMITTED, idstoNotify, "Submitted item RESTful Transaction Model", "Giorgino Giorgetti created the item RESTful Transaction Model. You are kindly requested to review it and decide either to APPROVE or REJECT it. ", new URL("https://data-dev.d4science.net/rU7T"));
        nc.sendCatalogueEvent(event);
    }

    @Test
    public void testWorkspaceItemEvents() throws Exception {
        NotificationClient nc = new NotificationClient();
        boolean vreFolder = false;
        FolderBean folder = new FolderBean("217cbe15-6408-41e5-9fda-628f56b8e803", "folderName", "folderTitle", "displayName", "/Workspace/_shared attachments", "90b8da48-d363-441a-a0a2-6f614ae747b9", vreFolder);
        FileItemBean fileItem = new FileItemBean("90b8da48-d363-441a-f0a2-4f413ae747d7", "updated item.pdf", "updated item.pdf", "/Workspace/_shared attachments/test updated item from client", folder);
        String[] idstoNotify = new String[]{"andrea.rossi"};
        UpdatedItemEvent event = new UpdatedItemEvent(idstoNotify, fileItem);
        nc.sendWorkspaceEvent((WorkspaceEvent)event);
        event = new AddedItemEvent(idstoNotify, fileItem);
        nc.sendWorkspaceEvent((WorkspaceEvent)event);
        event = new DeletedItemEvent(idstoNotify, "theDeletedFilenName.pdf", folder);
        nc.sendWorkspaceEvent((WorkspaceEvent)event);
        String[] contextIdstoNotify = new String[]{"/pred4s/preprod/preVRE"};
        event = new UpdatedItemEvent(contextIdstoNotify, true, fileItem);
        nc.sendWorkspaceEvent((WorkspaceEvent)event);
    }

    @Test
    public void testSearch() throws Exception {
        FullTextSearchClient search = new FullTextSearchClient();
        ArrayList result = search.search("looking for test", 0, 10);
        for (EnhancedFeed enhancedPost : result) {
            logger.debug("Returned post " + enhancedPost);
        }
    }

    public void testSearchEmptyList() throws Exception {
        FullTextSearchClient search = new FullTextSearchClient();
        ArrayList result = search.search("tipiterotipir\u00e8", 0, 10);
        for (EnhancedFeed enhancedFeed : result) {
            logger.debug("Returned feed " + enhancedFeed);
        }
    }

    @Test
    public void testHashTags() throws Exception {
        HashTagClient hashtags = new HashTagClient();
        Map hashtagsCount = hashtags.getHashtagsCount();
        logger.debug("Returned tags " + hashtagsCount);
    }

    @Test
    public void testMessagesReceived() throws Exception {
        MessageClient messagesClient = new MessageClient();
        List receivedMessages = messagesClient.getReceivedMessages();
        System.out.println("Messages found # " + receivedMessages.size());
        for (MessageInbox workspaceMessage : receivedMessages) {
            logger.debug("Received message  " + workspaceMessage.toString());
        }
    }

    @Test
    public void testMessagesSent() throws Exception {
        MessageClient messagesClient = new MessageClient();
        List sentMessages = messagesClient.getSentMessages();
        for (MessageInbox workspaceMessage : sentMessages) {
            logger.debug("Sent message was " + workspaceMessage);
        }
    }

    @Test
    public void sendMessage() throws Exception {
        logger.debug("Sending message ");
        MessageClient messagesClient = new MessageClient();
        List<Recipient> rec = Arrays.asList(new Recipient("andrea.rossi"), new Recipient("giancarlo.panichi"));
        MessageInputBean message = new MessageInputBean("Test message", "Sending message via client " + System.currentTimeMillis(), new ArrayList<Recipient>(rec));
        String idMessage = messagesClient.writeMessage(message);
        assert (idMessage != null);
    }

    @Test
    public void markMessageRead() throws Exception {
        logger.debug("markMessageRead message ");
        MessageClient messagesClient = new MessageClient();
        String idMessage = messagesClient.markMessageRead("a7b825c3-a0ca-42d7-b228-00b9e8f015e4", false);
        assert (idMessage != null);
    }

    public void testNotifications() throws Exception {
        NotificationClient notificationsClient = new NotificationClient();
        List latestNotifications = notificationsClient.getNotifications(1, 2);
        for (Notification notification : latestNotifications) {
            logger.debug("Notification is " + notification);
        }
    }

    @Test
    public void sendJobNotification() throws Exception {
        NotificationClient notificationsClient = new NotificationClient();
        JobNotificationBean notification = new JobNotificationBean("luca.frosini", UUID.randomUUID().toString(), "SmartExecutor Social Indexer", "SmartExecutor", JobStatusModelType.SUCCEEDED, "all ok");
        notificationsClient.sendJobNotification(notification);
        logger.debug("Sent job notification ");
    }

    @Test
    public void getProfile() throws Exception {
        PeopleClient getProfile = new PeopleClient();
        UserProfile profile = getProfile.getProfile();
        logger.debug("Profile retrieved is " + profile);
    }

    public void generateAppToken() throws Exception {
        TokenClient tokenClient = new TokenClient();
        String token = tokenClient.generateApplicationToken(new ApplicationId("org.gcube.datacatalogue.GRSFNotifier"));
        logger.debug("Generated token is  " + token);
    }

    public void getMyVres() throws Exception {
        VREClient myVresClient = new VREClient();
        List myVres = myVresClient.getMyVRES(false);
        logger.debug("My Vres  " + myVres);
    }

    @Test
    public void TestUsersClient() throws Exception {
        UserClient userClient = new UserClient();
        Set vreManagers = userClient.getAllUsernamesByRole("Data-Manager");
        assert (vreManagers != null && !vreManagers.isEmpty());
        System.out.println("Data Managers are " + vreManagers);
        String myEmail = userClient.getEmail();
        assert (myEmail != null && !myEmail.isEmpty());
        logger.debug("My email is " + myEmail);
        String fullname = userClient.getFullName();
        assert (fullname != null && !fullname.isEmpty());
        logger.debug("My fullname is " + fullname);
        String industry = userClient.getCustomAttribute("Industry");
        logger.debug("My Industry is " + industry);
        List usernamesInThisContext = userClient.getAllUsernamesContext();
        assert (usernamesInThisContext != null && !usernamesInThisContext.isEmpty());
        logger.debug("List of usernames in this context is  " + usernamesInThisContext);
        Map usernamesFullnameInThisContext = userClient.getAllUsernamesFullnamesContext();
        assert (usernamesFullnameInThisContext != null && !usernamesFullnameInThisContext.isEmpty());
        logger.debug("List of tuples usernames/fullnames in this context is  " + usernamesFullnameInThisContext);
        UserProfileExtended profile = userClient.getProfile();
        assert (profile != null);
        logger.debug("My wonderful profile is " + profile);
    }

    @Test
    public void getUserPostsSinceDate() throws Exception {
        PostClient postClient = new PostClient();
        List sinceLastYearPost = postClient.getUserPostsSinceDate(System.currentTimeMillis() - 1036800000L);
        logger.debug("Posts are " + sinceLastYearPost);
    }

    @Test
    public void getAllUserPosts() throws Exception {
        PostClient postClient = new PostClient();
        List allposts = postClient.getAllUserPosts();
        logger.debug("All posts found:");
        for (Post post : allposts) {
            logger.debug(post.toString());
        }
    }

    @Test
    public void getUserPostsQuantity() throws Exception {
        PostClient postClient = new PostClient();
        List quantityPosts = postClient.getUserPostsQuantity(3);
        logger.debug("Some posts are ");
        logger.debug(quantityPosts + " posts found:");
        for (Post post : quantityPosts) {
            logger.debug(post.toString());
        }
    }

    public void writeUserPost() throws Exception {
        PostClient postClient = new PostClient();
        PostInputBean toWrite = new PostInputBean("Testing social networking rest client", null, null, null, null, null, false, null);
        Post written = postClient.writeUserPost(toWrite);
        logger.debug("Written post is " + written);
    }

    public void getAllApplicationPosts() throws Exception {
        TokenClient tokenClient = new TokenClient();
        String token = tokenClient.generateApplicationToken(new ApplicationId("org.gcube.datacatalogue.GRSFNotifier"));
        logger.debug("Generated token is  " + token);
        String currentToken = SecurityTokenProvider.instance.get();
        SecurityTokenProvider.instance.set(token);
        PostClient postClient = new PostClient();
        List applicationPosts = postClient.getAllApplicationPosts();
        logger.debug("Application posts are " + applicationPosts);
        SecurityTokenProvider.instance.set(currentToken);
    }

    public void writeApplicationPost() throws Exception {
        TokenClient tokenClient = new TokenClient();
        String token = tokenClient.generateApplicationToken(new ApplicationId("org.gcube.datacatalogue.GRSFNotifier"));
        logger.debug("Generated token is  " + token);
        String currentToken = SecurityTokenProvider.instance.get();
        SecurityTokenProvider.instance.set(token);
        PostClient postClient = new PostClient();
        PostInputBean toWrite = new PostInputBean("Testing social networking rest client [via application token] #apptoken #rest #client #java", null, null, null, null, null, false, null);
        Post written = postClient.writeApplicationPost(toWrite);
        logger.debug("Written post is " + written);
        SecurityTokenProvider.instance.set(currentToken);
    }

    @Test
    public void getPostsVRE() throws Exception {
        PostClient postClient = new PostClient();
        List vrePosts = postClient.getVREPosts();
        logger.debug("VRE posts : ");
        for (Post post : vrePosts) {
            logger.debug(post.toString());
        }
    }

    public void getHashtagPosts() throws Exception {
        PostClient postClient = new PostClient();
        List postsWithHashtag = postClient.getHashtagPosts("#connect");
        logger.debug("Posts with hashtag #connect are " + postsWithHashtag);
    }

    @Test
    public void getUserLikedPost() throws Exception {
        PostClient postClient = new PostClient();
        List postsLiked = postClient.getUserLikedPost();
        logger.debug("Posts liked are " + postsLiked);
    }

    @Test
    public void getUserLikedPostIds() throws Exception {
        PostClient postClient = new PostClient();
        List postsLikedIds = postClient.getUserLikedPostIds();
        logger.debug("Posts liked's ids are " + postsLikedIds);
    }

    public void reset() {
        ScopeProvider.instance.reset();
        SecurityTokenProvider.instance.reset();
    }
}

