/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.social_networking_client_library.utils;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gcube.social_networking.model.providers.CustomObjectMapper;
import org.gcube.social_networking.social_networking_client_library.filter.AuthorizationFilter;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static Logger logger = LoggerFactory.getLogger(HttpClient.class);

    public static <R> R get(GenericType<ResponseBean<R>> returnType, String requestUrl) {
        logger.debug("Executing get request at url " + requestUrl);
        ClientConfig cc = new ClientConfig().register((Object)new JacksonFeature()).register((Object)new AuthorizationFilter()).register((Object)new CustomObjectMapper());
        Client client = ClientBuilder.newClient((Configuration)cc);
        WebTarget webResourceGet = client.target(requestUrl);
        Response response = webResourceGet.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get();
        if (response == null) {
            throw new WebApplicationException("Response returned by the service is null");
        }
        if (response.getStatus() >= 300) {
            throw new WebApplicationException("There was an error at server side: " + response.getStatusInfo());
        }
        ResponseBean result = (ResponseBean)response.readEntity(returnType);
        if (!result.isSuccess()) {
            throw new WebApplicationException("Error message is " + result.getMessage());
        }
        return (R)result.getResult();
    }

    public static <R> R post(GenericType<ResponseBean<R>> returnType, String requestUrl, Object obj) {
        logger.debug("Executing post request at url " + requestUrl);
        ClientConfig cc = new ClientConfig().register((Object)new JacksonFeature()).register((Object)new AuthorizationFilter()).register((Object)new CustomObjectMapper());
        Client client = ClientBuilder.newClient((Configuration)cc);
        WebTarget webResourceGet = client.target(requestUrl);
        logger.debug("Entity looks like " + Entity.json((Object)obj));
        Response response = webResourceGet.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).post(Entity.json((Object)obj));
        if (response == null) {
            throw new WebApplicationException("Response returned by the service is null");
        }
        if (response.getStatus() >= 300) {
            throw new WebApplicationException("There was an error at server side: " + response.getStatusInfo());
        }
        ResponseBean result = (ResponseBean)response.readEntity(returnType);
        if (!result.isSuccess()) {
            throw new WebApplicationException("Error message is " + result.getMessage());
        }
        return (R)result.getResult();
    }

    public static <R> R postFormData(GenericType<ResponseBean<R>> returnType, String requestUrl, Form form) {
        logger.debug("Executing post request at url " + requestUrl);
        ClientConfig cc = new ClientConfig().register((Object)new JacksonFeature()).register((Object)new AuthorizationFilter()).register((Object)new CustomObjectMapper());
        Client client = ClientBuilder.newClient((Configuration)cc);
        WebTarget webResourceGet = client.target(requestUrl);
        Invocation.Builder basicRequest = webResourceGet.request();
        Response response = (Response)basicRequest.post(Entity.form((Form)form), Response.class);
        if (response == null) {
            throw new WebApplicationException("Response returned by the service is null");
        }
        if (response.getStatus() >= 300) {
            throw new WebApplicationException("There was an error at server side: " + response.getStatusInfo());
        }
        ResponseBean result = (ResponseBean)response.readEntity(returnType);
        if (!result.isSuccess()) {
            throw new WebApplicationException("Error message is " + result.getMessage());
        }
        return (R)result.getResult();
    }
}

