/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.social_networking_client_library.utils;

import java.util.List;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.social_networking.social_networking_client_library.exceptions.NoSocialServiceAvailable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoverer {
    private static final String resource = "jersey-servlet";
    private static final String serviceName = "SocialNetworking";
    private static final String serviceClass = "Portal";
    private static Logger logger = LoggerFactory.getLogger(ServiceDiscoverer.class);
    private String entryPoint;

    public ServiceDiscoverer() throws Exception {
        String currentScope = ScopeProvider.instance.get();
        if (currentScope == null || currentScope.isEmpty()) {
            throw new RuntimeException("Scope is not set");
        }
        try {
            logger.debug("set scope " + currentScope);
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition(String.format("$resource/Profile/ServiceClass/text() eq '%s'", serviceClass));
            query.addCondition("$resource/Profile/DeploymentData/Status/text() eq 'ready'");
            query.addCondition(String.format("$resource/Profile/ServiceName/text() eq '%s'", serviceName));
            query.setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces//Endpoint[@EntryName/string() eq \"jersey-servlet\"]/text()");
            logger.debug("submitting quey " + query.toString());
            DiscoveryClient client = ICFactory.client();
            List endpoints = client.submit((Query)query);
            if (endpoints == null || endpoints.isEmpty()) {
                throw new NoSocialServiceAvailable("Cannot retrieve the GCoreEndpoint serviceName: SocialNetworking, serviceClass: Portal, in scope: " + currentScope);
            }
            this.entryPoint = (String)endpoints.get(0);
            if (this.entryPoint == null) {
                throw new NoSocialServiceAvailable("Endpoint:jersey-servlet, is null for serviceName: SocialNetworking, serviceClass: Portal, in scope: " + currentScope);
            }
            logger.info("found entryPoint " + this.entryPoint + " for social service: " + resource);
        }
        catch (Exception e) {
            String error = "An error occurred during GCoreEndpoint discovery, serviceName: SocialNetworking, serviceClass: Portal, in scope: " + currentScope + ".";
            logger.error(error, (Throwable)e);
            throw new Exception(error);
        }
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }
}

