package org.gcube.social_networking.socialnetworking.model.beans;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
/**
 * Used for serialization 
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Message {

	@JsonProperty("id")
	private String id;

	@JsonProperty("subject")
	@NotNull
	@Size(min=1, message="subject cannot be empty")
	private String subject;

	@JsonProperty("body")
	@NotNull
	@Size(min=1, message="body cannot be empty")
	private String body;

	@JsonProperty("sender")
	private String senderId;

	@JsonProperty("send_time")
	private Calendar sendTime;

	@JsonProperty("read")
	private boolean read;

	@JsonProperty("attachment_ids")
	private List<String> attachmentIds;

	@JsonProperty("recipients")
	@NotNull
	@Size(min=1, message="recipient cannot be empty")
	private List<Recipient> recipients;

	public Message() {
		super();
	}

	public Message(String id, String subject, String body,
			String senderId, Calendar sendTime, boolean read,
			List<String> attachmentIds, List<Recipient> recipients) {
		super();
		this.id = id;
		this.subject = subject;
		this.body = body;
		this.senderId = senderId;
		this.sendTime = sendTime;
		this.read = read;
		this.attachmentIds = attachmentIds;
		this.recipients = recipients;
	}

	public Message(String subject, String body, ArrayList<Recipient> recipients) {
		this.subject = subject;
		this.body = body;
		this.recipients = recipients;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getSenderId() {
		return senderId;
	}

	public void setSenderId(String senderId) {
		this.senderId = senderId;
	}

	public Calendar getSendTime() {
		return sendTime;
	}

	public void setSendTime(Calendar sendTime) {
		this.sendTime = sendTime;
	}

	public boolean isRead() {
		return read;
	}

	public void setRead(boolean read) {
		this.read = read;
	}

	public List<String> getAttachmentIds() {
		return attachmentIds;
	}

	public void setAttachmentIds(List<String> attachmentIds) {
		this.attachmentIds = attachmentIds;
	}

	public List<Recipient> getRecipients() {
		return recipients;
	}

	public void setRecipients(List<Recipient> recipients) {
		this.recipients = recipients;
	}

	@Override
	public String toString() {
		return "Message [id=" + id + ", subject=" + subject
				+ ", body=" + body + ", senderId=" + senderId + ", sendTime="
				+ sendTime + ", read=" + read + ", attachmentIds="
				+ attachmentIds + ", recipients=" + recipients + "]";
	}
}