package org.gcube.social_networking.socialnetworking.model.beans;

public enum WorkspaceNotificationType {

	/**
	 * use to notify a user she got a workspace item new in some of her workspace shared folder
	 */
	ITEM_NEW(WSAddedItemNotificationBean.class),
	/**
	 * use to notify a user he got a workspace folder shared
	 */
	FOLDER_SHARE(WSSharedFolderNotificationBean.class),
	/**
	 * use to notify a user he got a workspace folder Unshared
	 */
	FOLDER_UNSHARE(WSUnsharedFolderNotificationBean.class);
	
	
	
	Class<? extends WorkspaceNotificationBean> beanClass;
	
	WorkspaceNotificationType(Class<? extends WorkspaceNotificationBean> beanClass){
		this.beanClass = beanClass;
	}

	
	public Class<? extends WorkspaceNotificationBean> getNotificationClass(){
		return this.beanClass;
	}
	
}
