package org.gcube.social_networking.socialnetworking.model.beans;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeName("WSAddedItemNotificationBean")
@JsonIgnoreProperties(ignoreUnknown=true)
public class WSAddedItemNotificationBean extends WorkspaceNotificationBean {
	/**
	 * the username of the user you wish to notify
	 */
	@JsonProperty("userIdToNotify")
	@NotNull(message="recipient cannot be missing")
	private String userIdToNotify;	
	
	@JsonProperty("fileItem")
	@NotNull(message="fileItem cannot be missing")
	private WorkspaceFileItemBean item;
	
	@JsonProperty("folderItem")
	@NotNull(message="folderItem cannot be missing")
	private SharedFolderBean folder;
	
	public WSAddedItemNotificationBean() {
		super();
		// TODO Auto-generated constructor stub
	}

	public WSAddedItemNotificationBean(String userIdToNotify, WorkspaceFileItemBean item, SharedFolderBean folder) {
		super();
		this.userIdToNotify = userIdToNotify;
		this.item = item;
		this.folder = folder;
	}

	public String getUserIdToNotify() {
		return userIdToNotify;
	}

	public void setUserIdToNotify(String userIdToNotify) {
		this.userIdToNotify = userIdToNotify;
	}

	public WorkspaceFileItemBean getItem() {
		return item;
	}

	public void setItem(WorkspaceFileItemBean item) {
		this.item = item;
	}

	public SharedFolderBean getFolder() {
		return folder;
	}

	public void setFolder(SharedFolderBean folder) {
		this.folder = folder;
	}

	@Override
	public String toString() {
		return "WSAddedItemNotificationBean [userIdToNotify=" + userIdToNotify + ", item=" + item + ", folder=" + folder
				+ "]";
	}	
}
