package org.gcube.social_networking.socialnetworking.model.beans;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;


@JsonTypeName("FOLDER_SHARE")
@JsonIgnoreProperties(ignoreUnknown=true)
public class WSSharedFolderNotificationBean extends WorkspaceNotificationBean {

	/**
	 * the username of the user you wish to notify
	 */
	@JsonProperty("userIdToNotify")
	@NotNull(message="recipient cannot be missing")
	private String userIdToNotify;	
	
	@JsonProperty("folderItem")
	@NotNull(message="folderItem cannot be missing")
	private SharedFolderBean folder;

	public WSSharedFolderNotificationBean(String userIdToNotify, SharedFolderBean folder) {
		super();
		this.userIdToNotify = userIdToNotify;
		this.folder = folder;
	}

	public String getUserIdToNotify() {
		return userIdToNotify;
	}

	public void setUserIdToNotify(String userIdToNotify) {
		this.userIdToNotify = userIdToNotify;
	}

	public SharedFolderBean getFolder() {
		return folder;
	}

	public void setFolder(SharedFolderBean folder) {
		this.folder = folder;
	}

	@Override
	public String toString() {
		return "WSSharedFolderNotificationBean [userIdToNotify=" + userIdToNotify + ", folder=" + folder + "]";
	}	
}
