package org.gcube.social_networking.socialnetworking.model.beans;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo.As;

/**
 * The WorkspaceNotification super class
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, 
include = As.PROPERTY, property = "type") @JsonSubTypes({   
@JsonSubTypes.Type(value = WorkspaceNotificationSharedFolder.class, name = "FOLDER_SHARE"),
@JsonSubTypes.Type(value = WorkspaceNotificationUnsharedFolder.class, name = "FOLDER_UNSHARE"),
@JsonSubTypes.Type(value = WorkspaceNotificationAddedItem.class, name = "ITEM_NEW") 
})
public abstract class WorkspaceNotification {
	protected final WorkspaceNotificationType TYPE;
	
	WorkspaceNotification(WorkspaceNotificationType TYPE) {
		this.TYPE = TYPE;
	}
	
	public WorkspaceNotificationType TYPE() {
		return TYPE;
	}
}
