package org.gcube.social_networking.socialnetworking.model.beans;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("ITEM_NEW")
public class WorkspaceNotificationAddedItem extends WorkspaceNotification {
	/**
	 * the username of the user you wish to notify
	 */
	@JsonProperty("userIdToNotify")
	@NotNull(message="recipient cannot be missing")
	private String userIdToNotify;	
	
	@JsonProperty("fileItem")
	@NotNull(message="fileItem cannot be missing")
	private WorkspaceFileItemBean item;
	
	@JsonProperty("folderItem")
	@NotNull(message="folderItem cannot be missing")
	private WorkspaceFolderBean folder;
	
	public WorkspaceNotificationAddedItem() {
		super(WorkspaceNotificationType.ITEM_NEW);
		// TODO Auto-generated constructor stub
	}

	public WorkspaceNotificationAddedItem(String userIdToNotify, WorkspaceFileItemBean item, WorkspaceFolderBean folder) {
		super(WorkspaceNotificationType.ITEM_NEW);
		this.userIdToNotify = userIdToNotify;
		this.item = item;
		this.folder = folder;
	}

	public String getUserIdToNotify() {
		return userIdToNotify;
	}

	public void setUserIdToNotify(String userIdToNotify) {
		this.userIdToNotify = userIdToNotify;
	}

	public WorkspaceFileItemBean getItem() {
		return item;
	}

	public void setItem(WorkspaceFileItemBean item) {
		this.item = item;
	}

	public WorkspaceFolderBean getFolder() {
		return folder;
	}

	public void setFolder(WorkspaceFolderBean folder) {
		this.folder = folder;
	}

	@Override
	public String toString() {
		return "WorkspaceNotificationAddedItem [userIdToNotify=" + userIdToNotify + ", item=" + item + ", folder=" + folder
				+ "]";
	}	
}
