package org.gcube.social_networking.socialnetworking.model.beans.workspace;

public enum WorkspaceEventType {

	/**
	 * use to notify a user she got a workspace item new in some of her workspace shared folder
	 */
	ITEM_NEW(AddedItemEvent.class),
	/**
	 * use to notify a user he got a workspace folder shared
	 */
	FOLDER_SHARE(SharedFolderEvent.class),
	/**
	 * use to notify a user he got a workspace folder Unshared
	 */
	FOLDER_UNSHARE(UnsharedFolderEvent.class);
	
	
	
	Class<? extends WorkspaceEvent> beanClass;
	
	WorkspaceEventType(Class<? extends WorkspaceEvent> beanClass){
		this.beanClass = beanClass;
	}

	
	public Class<? extends WorkspaceEvent> getNotificationClass(){
		return this.beanClass;
	}
	
}
