/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.mappers;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.gcube.social_networking.utils.ResponseBean;

@Provider
public class ForbiddenExceptionMapper
implements ExceptionMapper<ForbiddenException> {
    public Response toResponse(ForbiddenException exception) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        String exceptionMessage = exception.getMessage();
        ResponseBean responseBean = null;
        try {
            if (exception.getCause() != null) {
                exceptionMessage = exception.getCause().getMessage();
            }
        }
        catch (Exception e) {
            exceptionMessage = exception.getMessage();
        }
        MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
        if (WebApplicationException.class.isAssignableFrom(exception.getClass())) {
            Response gotResponse = exception.getResponse();
            Object entity = gotResponse.getEntity();
            if (entity != null && ResponseBean.class.isAssignableFrom(entity.getClass())) {
                responseBean = (ResponseBean)entity;
            }
            status = Response.Status.fromStatusCode((int)gotResponse.getStatusInfo().getStatusCode());
        }
        if (responseBean == null) {
            responseBean = new ResponseBean();
        }
        responseBean.setSuccess(false);
        responseBean.setMessage(exceptionMessage);
        return Response.status((Response.Status)status).entity(responseBean).type(mediaType).build();
    }
}

