/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest.collections;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceGroup;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.gcube.social_networking.rest.collections.Collection;
import org.gcube.social_networking.socialnetworking.model.shared.Attachment;
import org.gcube.social_networking.socialnetworking.model.shared.IdResource;
import org.gcube.social_networking.utils.ResourceNames;
import org.gcube.social_networking.utils.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="attachments")
@ResourceGroup(value="Attachments APIs")
@ResourceLabel(value="Attachments APIs")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class Attachments
extends Collection {
    private static final Logger logger = LoggerFactory.getLogger(Attachments.class);

    private Response ErrorHandler(Exception e, String action, String id) {
        ResponseBean responseBean = new ResponseBean();
        logger.info("Unable to " + action + " attachment {}.", (Object)id);
        logger.info(e.getMessage());
        responseBean.setMessage(e.getMessage());
        responseBean.setSuccess(false);
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity(responseBean).build();
    }

    @POST
    @Path(value="")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAttachment(Attachment attachment) {
        try {
            logger.info("Creating attachment with id {}.", (Object)attachment.getId());
            return super.create((IdResource)attachment);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "create", attachment.getId());
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response readAttachment(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Reading attachment with id {}.", (Object)id);
            return super.read(id, ResourceNames.Attachment);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch", id);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteAttachment(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Deleting attachment with id {}.", (Object)id);
            return super.delete(id, ResourceNames.Attachment);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "delete", id);
        }
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateAttachment(@NotNull @PathParam(value="id") String id, @NotNull Attachment attachment) {
        try {
            logger.info("Updating attachment with id {}", (Object)id);
            return super.update(id, (IdResource)attachment);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "update", id);
        }
    }
}

