/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest.examples.serializers;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.gcube.com.fasterxml.jackson.core.type.TypeReference;
import org.gcube.com.fasterxml.jackson.databind.JsonSerializer;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.module.SimpleModule;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.security.SimpleCredentials;
import org.gcube.social_networking.rest.examples.serializers.ContainerConfigurationSerializer;
import org.gcube.social_networking.rest.examples.serializers.ContainerContextSerializer;
import org.gcube.social_networking.rest.examples.serializers.SimpleCredentialsSerializer;

public class IdmObjectSerializator {
    private static ObjectMapper serializer = null;
    protected static TypeReference<HashMap<String, Object>> typeRefHashmap = new TypeReference<HashMap<String, Object>>(){};

    public static String decodeBase64String(String encodedString) {
        return new String(Base64.getUrlDecoder().decode(encodedString), StandardCharsets.UTF_8);
    }

    public static HashMap<String, Object> jsonStringToHasmap(String jsonString) throws IOException {
        return (HashMap)IdmObjectSerializator.getSerializer().readValue(jsonString, typeRefHashmap);
    }

    public static ObjectMapper getSerializer() {
        if (serializer == null) {
            ObjectMapper om = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            module.addSerializer(ContainerConfiguration.class, (JsonSerializer)new ContainerConfigurationSerializer());
            module.addSerializer(ContainerContext.class, (JsonSerializer)new ContainerContextSerializer());
            module.addSerializer(SimpleCredentials.class, (JsonSerializer)new SimpleCredentialsSerializer());
            serializer = om;
        }
        return serializer;
    }
}

