/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest.collections;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceGroup;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.gcube.social_networking.rest.collections.Collection;
import org.gcube.social_networking.socialnetworking.model.shared.IdResource;
import org.gcube.social_networking.socialnetworking.model.shared.Invite;
import org.gcube.social_networking.utils.ResourceNames;
import org.gcube.social_networking.utils.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="invites")
@ResourceGroup(value="Invites APIs")
@ResourceLabel(value="Invites APIs")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class Invites
extends Collection {
    private static final Logger logger = LoggerFactory.getLogger(Invites.class);

    private Response ErrorHandler(Exception e, String action, String id) {
        ResponseBean responseBean = new ResponseBean();
        logger.info("Unable to " + action + " invite {}.", (Object)id);
        logger.info(e.getMessage());
        responseBean.setMessage(e.getMessage());
        responseBean.setSuccess(false);
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response readInvite(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Reading invite with id {}.", (Object)id);
            return super.read(id, ResourceNames.INVITE);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch", id);
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveInvite(@NotNull Invite invite) {
        try {
            logger.info("Saving invite with id {}.", (Object)invite.getId());
            return super.create((IdResource)invite);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "create", invite.getId());
        }
    }
}

