/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest.examples;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.security.Owner;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.utils.InnerMethodName;
import org.gcube.social_networking.rest.examples.serializers.IdmObjectSerializator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
public class HelloService {
    private final Logger logger = LoggerFactory.getLogger(HelloService.class);

    @GET
    @Path(value="hello")
    @Produces(value={"text/plain"})
    public String hello() {
        InnerMethodName.set((String)"hello");
        Secret secret = SecretManagerProvider.get();
        String userId = secret.getOwner().getId();
        String context = secret.getContext();
        String infrastructureName = ContextProvider.get().container().configuration().infrastructure();
        this.logger.info("caller id is {}", (Object)userId);
        return String.format("Hello %s in context %s in infastructure %s -roles %s", userId, context, infrastructureName, secret.getOwner().getRoles());
    }

    @GET
    @Path(value="details")
    @Produces(value={"application/json"})
    public Response details() {
        InnerMethodName.set((String)"details");
        HashMap<String, String> data = new HashMap<String, String>();
        Secret secret = SecretManagerProvider.get();
        String context = secret.getContext();
        data.put("context", context);
        Owner owner = secret.getOwner();
        data.put("owner", (String)owner);
        ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
        try {
            String jsonData = objectMapper.writeValueAsString(data);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }
}

