/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.collect.Maps;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.JmxConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.JmxConnectionPoolMonitorMBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolMBeanManager {
    private static Logger LOG = LoggerFactory.getLogger(ConnectionPoolMBeanManager.class);
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private static ConnectionPoolMBeanManager monitorInstance;
    private HashMap<String, JmxConnectionPoolMonitorMBean> monitors = Maps.newHashMap();

    private ConnectionPoolMBeanManager() {
    }

    public static ConnectionPoolMBeanManager getInstance() {
        if (monitorInstance == null) {
            monitorInstance = new ConnectionPoolMBeanManager();
        }
        return monitorInstance;
    }

    public synchronized void registerMonitor(String name, ConnectionPool<?> pool) {
        String monitorName = this.generateMonitorName(name);
        if (!this.monitors.containsKey(monitorName)) {
            try {
                LOG.info("Registering mbean: " + monitorName);
                ObjectName oName = new ObjectName(monitorName);
                JmxConnectionPoolMonitor mbean = new JmxConnectionPoolMonitor(pool);
                this.monitors.put(monitorName, mbean);
                this.mbs.registerMBean(mbean, oName);
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
                this.monitors.remove(monitorName);
            }
        }
    }

    public synchronized void unregisterMonitor(String name, ConnectionPool<?> pool) {
        String monitorName = this.generateMonitorName(name);
        this.monitors.remove(monitorName);
        try {
            this.mbs.unregisterMBean(new ObjectName(monitorName));
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public synchronized JmxConnectionPoolMonitorMBean getCassandraMonitor(String name) {
        String monitorName = this.generateMonitorName(name);
        return this.monitors.get(monitorName);
    }

    private String generateMonitorName(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("com.netflix.MonitoredResources");
        sb.append(":type=ASTYANAX");
        sb.append(",name=" + name);
        sb.append(",ServiceType=connectionpool");
        return sb.toString();
    }
}

