/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.OperationResult;
import java.util.concurrent.TimeUnit;

public class OperationResultImpl<R>
implements OperationResult<R> {
    private final Host host;
    private final R result;
    private final long latency;
    private int attemptCount = 0;

    public OperationResultImpl(Host host, R result, long latency) {
        this.host = host;
        this.result = result;
        this.latency = latency;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public R getResult() {
        return this.result;
    }

    @Override
    public long getLatency() {
        return this.latency;
    }

    @Override
    public long getLatency(TimeUnit units) {
        return units.convert(this.latency, TimeUnit.NANOSECONDS);
    }

    @Override
    public int getAttemptsCount() {
        return this.attemptCount;
    }

    @Override
    public void setAttemptsCount(int count) {
        this.attemptCount = count;
    }
}

