/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.test;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;

public class ProbabalisticFunction<T, R>
implements Function<T, R> {
    private ArrayList<Entry<T, R>> functions = Lists.newArrayList();
    private Function<T, R> defaultFunction;
    private Runnable always;

    public R apply(T arg) {
        this.always.run();
        double p = new Random().nextDouble();
        for (Entry<T, R> entry : this.functions) {
            if (!(entry.probability > p)) continue;
            return (R)entry.function.apply(arg);
        }
        return (R)this.defaultFunction.apply(arg);
    }

    public static class Entry<T, R> {
        double probability;
        Function<T, R> function;

        Entry(double probability, Function<T, R> function) {
            this.probability = probability;
            this.function = function;
        }
    }

    public static class Builder<T, R> {
        private ProbabalisticFunction<T, R> function = new ProbabalisticFunction();
        private double counter = 0.0;

        public Builder<T, R> withProbability(double probability, Function<T, R> func) {
            this.counter += probability;
            ((ProbabalisticFunction)this.function).functions.add(new Entry<T, R>(this.counter, func));
            return this;
        }

        public Builder<T, R> withDefault(Function<T, R> func) {
            ((ProbabalisticFunction)this.function).defaultFunction = func;
            return this;
        }

        public Builder<T, R> withAlways(Runnable func) {
            ((ProbabalisticFunction)this.function).always = func;
            return this;
        }

        public Function<T, R> build() {
            return this.function;
        }
    }
}

