/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.google.common.base.Optional;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicPropertySupport;
import com.netflix.config.PropertyListener;
import com.netflix.config.validation.PropertyChangeValidator;
import com.netflix.config.validation.ValidationException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicProperty {
    private static final Logger logger = LoggerFactory.getLogger(DynamicProperty.class);
    private static volatile DynamicPropertySupport dynamicPropertySupportImpl;
    private static final ConcurrentHashMap<String, DynamicProperty> ALL_PROPS;
    private Object lock = new Object();
    private String propName;
    private String stringValue = null;
    private long changedTime;
    private CopyOnWriteArraySet<Runnable> callbacks = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<PropertyChangeValidator> validators = new CopyOnWriteArraySet();
    private static final String[] TRUE_VALUES;
    private static final String[] FALSE_VALUES;
    private CachedValue<Boolean> booleanValue = new CachedValue<Boolean>(){

        @Override
        protected Boolean parse(String rep) throws IllegalArgumentException {
            int i;
            for (i = 0; i < TRUE_VALUES.length; ++i) {
                if (!rep.equalsIgnoreCase(TRUE_VALUES[i])) continue;
                return Boolean.TRUE;
            }
            for (i = 0; i < FALSE_VALUES.length; ++i) {
                if (!rep.equalsIgnoreCase(FALSE_VALUES[i])) continue;
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException();
        }
    };
    private CachedValue<String> cachedStringValue = new CachedValue<String>(){

        @Override
        protected String parse(String rep) {
            return rep;
        }
    };
    private CachedValue<Integer> integerValue = new CachedValue<Integer>(){

        @Override
        protected Integer parse(String rep) throws NumberFormatException {
            return Integer.valueOf(rep);
        }
    };
    private CachedValue<Long> longValue = new CachedValue<Long>(){

        @Override
        protected Long parse(String rep) throws NumberFormatException {
            return Long.valueOf(rep);
        }
    };
    private CachedValue<Float> floatValue = new CachedValue<Float>(){

        @Override
        protected Float parse(String rep) throws NumberFormatException {
            return Float.valueOf(rep);
        }
    };
    private CachedValue<Double> doubleValue = new CachedValue<Double>(){

        @Override
        protected Double parse(String rep) throws NumberFormatException {
            return Double.valueOf(rep);
        }
    };
    private CachedValue<Class> classValue = new CachedValue<Class>(){

        @Override
        protected Class parse(String rep) throws ClassNotFoundException {
            return Class.forName(rep);
        }
    };

    public static DynamicProperty getInstance(String propName) {
        DynamicProperty oldProp;
        DynamicProperty prop;
        if (dynamicPropertySupportImpl == null) {
            DynamicPropertyFactory.getInstance();
        }
        if ((prop = ALL_PROPS.get(propName)) == null && (oldProp = ALL_PROPS.putIfAbsent(propName, prop = new DynamicProperty(propName))) != null) {
            prop = oldProp;
        }
        return prop;
    }

    protected DynamicProperty() {
    }

    private DynamicProperty(String propName) {
        this.propName = propName;
        this.updateValue();
    }

    public String getName() {
        return this.propName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChangedTimestamp() {
        Object object = this.lock;
        synchronized (object) {
            return this.changedTime;
        }
    }

    public String getString() {
        return this.cachedStringValue.getValue();
    }

    public String getString(String defaultValue) {
        return this.cachedStringValue.getValue(defaultValue);
    }

    public Boolean getBoolean() throws IllegalArgumentException {
        return this.booleanValue.getValue();
    }

    public Boolean getBoolean(Boolean defaultValue) {
        return this.booleanValue.getValue(defaultValue);
    }

    public Integer getInteger() throws IllegalArgumentException {
        return this.integerValue.getValue();
    }

    public Integer getInteger(Integer defaultValue) {
        return this.integerValue.getValue(defaultValue);
    }

    public Float getFloat() throws IllegalArgumentException {
        return this.floatValue.getValue();
    }

    public Float getFloat(Float defaultValue) {
        return this.floatValue.getValue(defaultValue);
    }

    public Long getLong() throws IllegalArgumentException {
        return this.longValue.getValue();
    }

    public Long getLong(Long defaultValue) {
        return this.longValue.getValue(defaultValue);
    }

    public Double getDouble() throws IllegalArgumentException {
        return this.doubleValue.getValue();
    }

    public Double getDouble(Double defaultValue) {
        return this.doubleValue.getValue(defaultValue);
    }

    public Class getNamedClass() throws IllegalArgumentException {
        return this.classValue.getValue();
    }

    public Class<?> getNamedClass(Class<?> defaultValue) {
        return this.classValue.getValue(defaultValue);
    }

    public <T> Optional<T> getCachedValue(Class<T> objectType) {
        Object result = null;
        try {
            if (Integer.class.equals(objectType)) {
                result = this.integerValue.getValue();
            } else if (String.class.equals(objectType)) {
                result = this.cachedStringValue.getValue();
            } else if (Boolean.class.equals(objectType)) {
                result = this.booleanValue.getValue();
            } else if (Float.class.equals(objectType)) {
                result = this.floatValue.getValue();
            } else if (Double.class.equals(objectType)) {
                result = this.doubleValue.getValue();
            } else if (Long.class.equals(objectType)) {
                result = this.longValue.getValue();
            } else if (Class.class.equals(objectType)) {
                result = this.classValue.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            return Optional.absent();
        }
        return Optional.of(result);
    }

    public void addCallback(Runnable r) {
        if (r == null) {
            throw new NullPointerException("Cannot add null callback to DynamicProperty");
        }
        this.callbacks.add(r);
    }

    public void addValidator(PropertyChangeValidator validator) {
        if (validator == null) {
            throw new NullPointerException("Cannot add null validator to DynamicProperty");
        }
        this.validators.add(validator);
    }

    public boolean removeCallback(Runnable r) {
        return this.callbacks.remove(r);
    }

    Set<Runnable> getCallbacks() {
        return this.callbacks;
    }

    private void notifyCallbacks() {
        for (Runnable r : this.callbacks) {
            try {
                r.run();
            }
            catch (Exception e) {
                logger.error("Error in DynamicProperty callback", (Throwable)e);
            }
        }
    }

    private void validate(String newValue) {
        for (PropertyChangeValidator v : this.validators) {
            try {
                v.validate(newValue);
            }
            catch (ValidationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ValidationException("Unexpected exception during validation", e);
            }
        }
    }

    private boolean updateValue() {
        String newValue;
        try {
            if (dynamicPropertySupportImpl == null) {
                return false;
            }
            newValue = dynamicPropertySupportImpl.getString(this.propName);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Unable to update property: " + this.propName, (Throwable)e);
            return false;
        }
        return this.updateValue(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateValue(Object newValue) {
        String nv = newValue == null ? null : newValue.toString();
        Object object = this.lock;
        synchronized (object) {
            if (nv == null && this.stringValue == null || nv != null && nv.equals(this.stringValue)) {
                return false;
            }
            this.stringValue = nv;
            this.cachedStringValue.flush();
            this.booleanValue.flush();
            this.integerValue.flush();
            this.floatValue.flush();
            this.classValue.flush();
            this.doubleValue.flush();
            this.longValue.flush();
            this.changedTime = System.currentTimeMillis();
            return true;
        }
    }

    private static boolean updateProperty(String propName, Object value) {
        DynamicProperty prop = ALL_PROPS.get(propName);
        if (prop != null && prop.updateValue(value)) {
            prop.notifyCallbacks();
            return true;
        }
        return false;
    }

    private static boolean updateAllProperties() {
        boolean changed = false;
        for (DynamicProperty prop : ALL_PROPS.values()) {
            if (!prop.updateValue()) continue;
            prop.notifyCallbacks();
            changed = true;
        }
        return changed;
    }

    private static void validate(String propName, Object value) {
        DynamicProperty prop = ALL_PROPS.get(propName);
        if (prop != null) {
            String newValue = value == null ? null : value.toString();
            prop.validate(newValue);
        }
    }

    static synchronized void initialize(DynamicPropertySupport config) {
        dynamicPropertySupportImpl = config;
        config.addConfigurationListener(new DynamicPropertyListener());
        DynamicProperty.updateAllProperties();
    }

    static void registerWithDynamicPropertySupport(DynamicPropertySupport config) {
        DynamicProperty.initialize(config);
    }

    public String toString() {
        return "{DynamicProperty:" + this.propName + "}";
    }

    static {
        ALL_PROPS = new ConcurrentHashMap();
        TRUE_VALUES = new String[]{"true", "t", "yes", "y", "on"};
        FALSE_VALUES = new String[]{"false", "f", "no", "n", "off"};
    }

    static class DynamicPropertyListener
    implements PropertyListener {
        DynamicPropertyListener() {
        }

        @Override
        public void configSourceLoaded(Object source) {
            DynamicProperty.updateAllProperties();
        }

        @Override
        public void addProperty(Object source, String name, Object value, boolean beforeUpdate) {
            if (!beforeUpdate) {
                DynamicProperty.updateProperty(name, value);
            } else {
                DynamicProperty.validate(name, value);
            }
        }

        @Override
        public void setProperty(Object source, String name, Object value, boolean beforeUpdate) {
            if (!beforeUpdate) {
                DynamicProperty.updateProperty(name, value);
            } else {
                DynamicProperty.validate(name, value);
            }
        }

        @Override
        public void clearProperty(Object source, String name, Object value, boolean beforeUpdate) {
            if (!beforeUpdate) {
                DynamicProperty.updateProperty(name, value);
            }
        }

        @Override
        public void clear(Object source, boolean beforeUpdate) {
            if (!beforeUpdate) {
                DynamicProperty.updateAllProperties();
            }
        }
    }

    private abstract class CachedValue<T> {
        private volatile boolean isCached;
        private volatile IllegalArgumentException exception;
        private volatile T value;

        public CachedValue() {
            this.flush();
        }

        final void flush() {
            this.isCached = false;
            this.exception = null;
            this.value = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getValue() throws IllegalArgumentException {
            if (!this.isCached) {
                Object object = DynamicProperty.this.lock;
                synchronized (object) {
                    try {
                        this.value = DynamicProperty.this.stringValue == null ? null : this.parse(DynamicProperty.this.stringValue);
                        this.exception = null;
                    }
                    catch (Exception e) {
                        this.value = null;
                        this.exception = new IllegalArgumentException(e);
                    }
                    finally {
                        this.isCached = true;
                    }
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }

        public T getValue(T defaultValue) {
            try {
                T result = this.getValue();
                return result == null ? defaultValue : result;
            }
            catch (IllegalArgumentException e) {
                return defaultValue;
            }
        }

        public String toString() {
            if (!this.isCached) {
                return "{not cached}";
            }
            if (this.exception != null) {
                return "{Exception: " + this.exception + "}";
            }
            return "{Value: " + this.value + "}";
        }

        protected abstract T parse(String var1) throws Exception;
    }
}

