/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.executor;

import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.executor.PortalExecutorManager;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PortalExecutorManagerUtil {
    private static PortalExecutorManager _portalExecutorManager;

    public static <T> Future<T> execute(String name, Callable<T> callable) {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        return PortalExecutorManagerUtil.getPortalExecutorManager().execute(name, callable);
    }

    public static <T> T execute(String name, Callable<T> callable, long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        return PortalExecutorManagerUtil.getPortalExecutorManager().execute(name, callable, timeout, timeUnit);
    }

    public static ThreadPoolExecutor getPortalExecutor(String name) {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        return PortalExecutorManagerUtil.getPortalExecutorManager().getPortalExecutor(name);
    }

    public static ThreadPoolExecutor getPortalExecutor(String name, boolean createIfAbsent) {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        return PortalExecutorManagerUtil.getPortalExecutorManager().getPortalExecutor(name, createIfAbsent);
    }

    public static PortalExecutorManager getPortalExecutorManager() {
        PortalRuntimePermission.checkGetBeanProperty(PortalExecutorManagerUtil.class);
        return _portalExecutorManager;
    }

    public static ThreadPoolExecutor registerPortalExecutor(String name, ThreadPoolExecutor threadPoolExecutor) {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        return PortalExecutorManagerUtil.getPortalExecutorManager().registerPortalExecutor(name, threadPoolExecutor);
    }

    public static void shutdown() {
        PortalRuntimePermission.checkThreadPoolExecutor("<<ALL EXECUTORS>>");
        PortalExecutorManagerUtil.getPortalExecutorManager().shutdown();
    }

    public static void shutdown(boolean interrupt) {
        PortalRuntimePermission.checkThreadPoolExecutor("<<ALL EXECUTORS>>");
        PortalExecutorManagerUtil.getPortalExecutorManager().shutdown(interrupt);
    }

    public static void shutdown(String name) {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        PortalExecutorManagerUtil.getPortalExecutorManager().shutdown(name);
    }

    public static void shutdown(String name, boolean interrupt) {
        PortalRuntimePermission.checkThreadPoolExecutor(name);
        PortalExecutorManagerUtil.getPortalExecutorManager().shutdown(name, interrupt);
    }

    public void setPortalExecutorManager(PortalExecutorManager portalExecutorManager) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _portalExecutorManager = portalExecutorManager;
    }
}

