/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.mpi;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.config.MessagingConfigurator;
import com.liferay.portal.kernel.messaging.config.MessagingConfiguratorRegistry;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.IntrabandFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.rpc.BootstrapRPCDatagramReceiveHandler;
import com.liferay.portal.kernel.resiliency.mpi.MPI;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIConfiguration;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryUtil;
import com.liferay.portal.kernel.resiliency.spi.provider.SPIProvider;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MPIHelperUtil {
    private static Log _log = LogFactoryUtil.getLog(MPIHelperUtil.class);
    private static Intraband _intraband;
    private static Lock _lock;
    private static MPI _mpi;
    private static MPI _mpiImpl;
    private static ConcurrentMap<String, SPIProvider> _spiProviders;
    private static ConcurrentMap<SPIKey, SPI> _spis;

    static {
        _lock = new ReentrantLock();
        _spiProviders = new ConcurrentHashMap<String, SPIProvider>();
        _spis = new ConcurrentHashMap<SPIKey, SPI>();
        _mpiImpl = new MPIImpl();
        try {
            if (PropsUtil.getProps() != null) {
                System.setProperty("intraband.impl", PropsUtil.get("intraband.impl"));
                System.setProperty("intraband.timeout.default", PropsUtil.get("intraband.timeout.default"));
                System.setProperty("intraband.welder.impl", PropsUtil.get("intraband.welder.impl"));
            }
            _intraband = IntrabandFactoryUtil.createIntraband();
            _intraband.registerDatagramReceiveHandler(SystemDataType.RPC.getValue(), new BootstrapRPCDatagramReceiveHandler());
            _mpi = (MPI)UnicastRemoteObject.exportObject((Remote)_mpiImpl, 0);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static Intraband getIntraband() {
        return _intraband;
    }

    public static MPI getMPI() {
        return _mpi;
    }

    public static SPI getSPI(String spiProviderName, String spiId) {
        SPIKey spiKey = new SPIKey(spiProviderName, spiId);
        SPI spi = (SPI)_spis.get(spiKey);
        if (spi != null) {
            spi = MPIHelperUtil._checkSPILiveness(spi);
        }
        return spi;
    }

    public static SPIProvider getSPIProvider(String spiProviderName) {
        return (SPIProvider)_spiProviders.get(spiProviderName);
    }

    public static List<SPIProvider> getSPIProviders() {
        return new ArrayList<SPIProvider>(_spiProviders.values());
    }

    public static List<SPI> getSPIs() {
        ArrayList<SPI> spis = new ArrayList<SPI>();
        for (SPI spi : _spis.values()) {
            if ((spi = MPIHelperUtil._checkSPILiveness(spi)) == null) continue;
            spis.add(spi);
        }
        return spis;
    }

    public static List<SPI> getSPIs(String spiProviderName) {
        ArrayList<SPI> spis = new ArrayList<SPI>();
        for (Map.Entry entry : _spis.entrySet()) {
            SPIKey spiKey = (SPIKey)entry.getKey();
            if (!spiProviderName.equals(spiKey._spiProviderName)) continue;
            SPI spi = (SPI)entry.getValue();
            if ((spi = MPIHelperUtil._checkSPILiveness(spi)) == null) continue;
            spis.add(spi);
        }
        return spis;
    }

    public static boolean registerSPI(SPI spi) {
        _lock.lock();
        try {
            MPI mpi = spi.getMPI();
            if (mpi != _mpi) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Not registering SPI " + spi + " with foreign MPI " + mpi + " versus " + _mpi);
                }
                return false;
            }
            String spiProviderName = spi.getSPIProviderName();
            SPIProvider spiProvider = (SPIProvider)_spiProviders.get(spiProviderName);
            if (spiProvider == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Not registering SPI " + spi + " with unknown SPI provider " + spiProviderName);
                }
                return false;
            }
            SPIConfiguration spiConfiguration = spi.getSPIConfiguration();
            SPIKey spiKey = new SPIKey(spiProviderName, spiConfiguration.getSPIId());
            SPI previousSPI = _spis.putIfAbsent(spiKey, spi);
            if (previousSPI != null) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Not registering SPI " + spi + " because it duplicates " + previousSPI);
                }
                return false;
            }
            SPIRegistryUtil.registerSPI(spi);
            String[] stringArray = spiConfiguration.getServletContextNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String servletContextName = stringArray[n2];
                List<MessagingConfigurator> messagingConfigurators = MessagingConfiguratorRegistry.getMessagingConfigurators(servletContextName);
                if (messagingConfigurators != null) {
                    for (MessagingConfigurator messagingConfigurator : messagingConfigurators) {
                        messagingConfigurator.disconnect();
                    }
                }
                ++n2;
            }
            if (_log.isInfoEnabled()) {
                _log.info("Registered SPI " + spi);
            }
            return true;
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
        finally {
            _lock.unlock();
        }
    }

    public static boolean registerSPIProvider(SPIProvider spiProvider) {
        String spiProviderName = spiProvider.getName();
        SPIProvider previousSPIProvider = null;
        _lock.lock();
        try {
            previousSPIProvider = _spiProviders.putIfAbsent(spiProviderName, spiProvider);
        }
        finally {
            _lock.unlock();
        }
        if (previousSPIProvider != null) {
            if (_log.isWarnEnabled()) {
                _log.warn("Not registering SPI provider " + spiProvider + " because it duplicates " + previousSPIProvider);
            }
            return false;
        }
        if (_log.isInfoEnabled()) {
            _log.info("Registered SPI provider " + spiProvider);
        }
        return true;
    }

    public static void shutdown() {
        block2: {
            try {
                UnicastRemoteObject.unexportObject(_mpiImpl, true);
            }
            catch (NoSuchObjectException nsoe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn("Unable to unexport " + _mpiImpl, nsoe);
            }
        }
    }

    public static boolean unregisterSPI(SPI spi) {
        _lock.lock();
        try {
            MPI mpi = spi.getMPI();
            if (mpi != _mpi) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Not unregistering SPI " + spi + " with foreign MPI " + mpi + " versus " + _mpi);
                }
                return false;
            }
            String spiProviderName = spi.getSPIProviderName();
            SPIProvider spiProvider = (SPIProvider)_spiProviders.get(spiProviderName);
            if (spiProvider == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Not unregistering SPI " + spi + " with unknown SPI provider " + spiProviderName);
                }
                return false;
            }
            SPIConfiguration spiConfiguration = spi.getSPIConfiguration();
            String spiId = spiConfiguration.getSPIId();
            SPIKey spiKey = new SPIKey(spiProviderName, spiId);
            if (_spis.remove(spiKey, spi)) {
                SPIRegistryUtil.unregisterSPI(spi);
                String[] stringArray = spiConfiguration.getServletContextNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String servletContextName = stringArray[n2];
                    List<MessagingConfigurator> messagingConfigurators = MessagingConfiguratorRegistry.getMessagingConfigurators(servletContextName);
                    if (messagingConfigurators != null) {
                        for (MessagingConfigurator messagingConfigurator : messagingConfigurators) {
                            messagingConfigurator.connect();
                        }
                    }
                    ++n2;
                }
                if (_log.isInfoEnabled()) {
                    _log.info("Unregistered SPI " + spi);
                }
                return true;
            }
            if (_log.isWarnEnabled()) {
                _log.warn("Not unregistering unregistered SPI " + spi);
            }
            return false;
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
        finally {
            _lock.unlock();
        }
    }

    public static boolean unregisterSPIProvider(SPIProvider spiProvider) {
        _lock.lock();
        try {
            String spiProviderName = spiProvider.getName();
            if (_spiProviders.remove(spiProviderName, spiProvider)) {
                for (Map.Entry entry : _spis.entrySet()) {
                    SPIKey spiKey = (SPIKey)entry.getKey();
                    if (!spiProviderName.equals(spiKey._spiProviderName)) continue;
                    SPI spi = (SPI)entry.getValue();
                    try {
                        spi.destroy();
                        if (!_log.isInfoEnabled()) continue;
                        _log.info("Unregistered SPI " + spi + " while unregistering SPI provider " + spiProvider);
                    }
                    catch (RemoteException re) {
                        _log.error("Unable to unregister SPI " + spi + " while unregistering SPI provider " + spiProvider, re);
                    }
                }
                if (_log.isInfoEnabled()) {
                    _log.info("Unregistered SPI provider " + spiProvider);
                }
                return true;
            }
            if (_log.isWarnEnabled()) {
                _log.warn("Not unregistering unregistered SPI provider " + spiProvider);
            }
            return false;
        }
        finally {
            _lock.unlock();
        }
    }

    private static SPI _checkSPILiveness(SPI spi) {
        boolean alive = false;
        try {
            alive = spi.isAlive();
        }
        catch (RemoteException re) {
            _log.error(re);
        }
        if (alive) {
            return spi;
        }
        MPIHelperUtil.unregisterSPI(spi);
        return null;
    }

    private static class MPIImpl
    implements MPI {
        private MPIImpl() {
        }

        @Override
        public boolean isAlive() {
            return true;
        }
    }

    private static class SPIKey {
        private String _spiId;
        private String _spiProviderName;

        public SPIKey(String spiProviderName, String spiId) {
            this._spiProviderName = spiProviderName;
            this._spiId = spiId;
        }

        public boolean equals(Object obj) {
            SPIKey spiKey = (SPIKey)obj;
            return Validator.equals(this._spiProviderName, spiKey._spiProviderName) && Validator.equals(this._spiId, spiKey._spiId);
        }

        public int hashCode() {
            return this._spiProviderName.hashCode() * 11 + this._spiId.hashCode();
        }

        public String toString() {
            return this._spiProviderName.concat("#").concat(this._spiId);
        }
    }
}

