/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.config;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.config.AbstractSchedulingConfigurator;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;

public class PluginSchedulingConfigurator
extends AbstractSchedulingConfigurator {
    private static Log _log = LogFactoryUtil.getLog(PluginSchedulingConfigurator.class);

    @Override
    public void configure() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        String servletContextName = PortletClassLoaderUtil.getServletContextName();
        boolean forceSync = ProxyModeThreadLocal.isForceSync();
        ProxyModeThreadLocal.setForceSync(true);
        try {
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            currentThread.setContextClassLoader(portalClassLoader);
            for (SchedulerEntry schedulerEntry : this.schedulerEntries) {
                try {
                    SchedulerEngineHelperUtil.schedule(schedulerEntry, this.storageType, servletContextName, this.exceptionsMaxSize);
                }
                catch (Exception e) {
                    _log.error("Unable to schedule " + schedulerEntry, e);
                }
            }
        }
        finally {
            ProxyModeThreadLocal.setForceSync(forceSync);
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void destroy() {
        for (SchedulerEntry schedulerEntry : this.schedulerEntries) {
            try {
                SchedulerEngineHelperUtil.delete(schedulerEntry, this.storageType);
            }
            catch (Exception e) {
                _log.error("Unable to unschedule " + schedulerEntry, e);
            }
        }
        this.schedulerEntries.clear();
    }
}

