/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.model.CqlResult;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.query.ColumnQuery;
import com.netflix.astyanax.query.RowQuery;
import com.netflix.astyanax.serializers.ObjectSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.util.RangeBuilder;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class CFStandardTests
extends KeyspaceTests {
    private static final Logger LOG = Logger.getLogger(CFStandardTests.class);
    public static ColumnFamily<String, String> CF_STANDARD1 = ColumnFamily.newColumnFamily((String)"Standard1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
    public static ColumnFamily<String, String> CF_STANDARD2 = ColumnFamily.newColumnFamily((String)"Standard2", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
    private static ColumnFamily<String, String> CF_USER_INFO = ColumnFamily.newColumnFamily((String)"UserInfo", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        CFStandardTests.initContext();
        keyspace.createColumnFamily(CF_STANDARD1, null);
        keyspace.createColumnFamily(CF_STANDARD2, null);
        keyspace.createColumnFamily(CF_USER_INFO, null);
        CF_STANDARD1.describe(keyspace);
        CF_STANDARD2.describe(keyspace);
        CF_USER_INFO.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_STANDARD1);
        keyspace.dropColumnFamily(CF_STANDARD2);
        keyspace.dropColumnFamily(CF_USER_INFO);
    }

    @Test
    public void testSerializedClassValue() throws Exception {
        UserInfo smo = new UserInfo();
        smo.setLastName("Landau");
        smo.setFirstName("Eran");
        ByteBuffer bb = ObjectSerializer.get().toByteBuffer((Object)smo);
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)"Key_SerializeTest", (Object)"Column1").putValue(bb, null).execute();
        UserInfo smo2 = (UserInfo)((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)"Key_SerializeTest").getColumn((Object)"Column1").execute().getResult()).getValue((Serializer)ObjectSerializer.get());
        Assert.assertEquals((Object)smo, (Object)smo2);
    }

    @Test
    public void testSingleOps() throws Exception {
        String key = "SingleOpsTest";
        Random prng = new Random();
        String column = "StringColumn";
        String value = RandomStringUtils.randomAlphanumeric((int)32);
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).putValue(value, null).execute();
        ColumnQuery query = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column);
        String v = ((Column)query.execute().getResult()).getStringValue();
        Assert.assertEquals((String)value, (String)v);
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).deleteColumn().execute();
        try {
            ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getStringValue();
            Assert.fail();
        }
        catch (RuntimeException e) {
        }
        catch (NotFoundException e) {
        }
        catch (ConnectionException e) {
            e.printStackTrace();
            Assert.fail();
        }
        column = "ByteColumn";
        short value2 = (short)prng.nextInt(127);
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).putValue((byte)value2, null).execute();
        int v2 = ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getByteValue();
        Assert.assertEquals((byte)value2, (byte)v2);
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).deleteColumn().execute();
        try {
            ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getByteValue();
            Assert.fail();
        }
        catch (NullPointerException e) {
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        column = "ShortColumn";
        value2 = (short)prng.nextInt(Short.MAX_VALUE);
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).putValue(value2, null).execute();
        v2 = ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getShortValue();
        Assert.assertEquals((short)value2, (short)v2);
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).deleteColumn().execute();
        try {
            ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getShortValue();
            Assert.fail();
        }
        catch (NullPointerException e) {
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        column = "IntColumn";
        value2 = (short)prng.nextInt();
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).putValue((int)value2, null).execute();
        v2 = ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getIntegerValue();
        Assert.assertEquals((int)value2, (int)v2);
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).deleteColumn().execute();
        try {
            ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getIntegerValue();
            Assert.fail();
        }
        catch (NullPointerException e) {
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        column = "LongColumn";
        long value3 = prng.nextLong();
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).putValue(value3, null).execute();
        long v22 = ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getLongValue();
        Assert.assertEquals((long)value3, (long)v22);
        try {
            ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getIntegerValue();
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).deleteColumn().execute();
        try {
            ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getLongValue();
            Assert.fail();
        }
        catch (NullPointerException e) {
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        column = "FloatColumn";
        float value4 = prng.nextFloat();
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).putValue(value4, null).execute();
        float v3 = ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getFloatValue();
        Assert.assertEquals((Object)Float.valueOf(value4), (Object)Float.valueOf(v3));
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).deleteColumn().execute();
        try {
            ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getFloatValue();
            Assert.fail();
        }
        catch (NullPointerException e) {
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        column = "DoubleColumn";
        double value5 = prng.nextDouble();
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).putValue(value5, null).execute();
        double v4 = ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getDoubleValue();
        Assert.assertEquals((Object)value5, (Object)v4);
        try {
            ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getIntegerValue();
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).deleteColumn().execute();
        try {
            ((Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult()).getDoubleValue();
            Assert.fail();
        }
        catch (NullPointerException e) {
        }
        catch (NotFoundException e) {
        }
        catch (ConnectionException e) {
            Assert.fail();
        }
        column = "TimestampColumn";
        long value6 = prng.nextLong();
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)key, (Object)column).withTimestamp(100L).putValue(value6, null).execute();
        Column c = (Column)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)key).getColumn((Object)column).execute().getResult();
        Assert.assertEquals((long)100L, (long)c.getTimestamp());
    }

    @Test
    public void testEmptyColumn() {
        ColumnListMutation mutation = keyspace.prepareMutationBatch().withRow(CF_STANDARD1, (Object)"ABC");
        try {
            mutation.putColumn(null, 1L);
            Assert.fail();
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            mutation.putColumn((Object)"", 1L);
            Assert.fail();
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            mutation.deleteColumn((Object)"");
            Assert.fail();
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            mutation.deleteColumn(null);
            Assert.fail();
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
    }

    @Test
    public void testCqlCount() throws Exception {
        LOG.info((Object)"CQL Test");
        OperationResult result = keyspace.prepareQuery(CF_STANDARD1).withCql("SELECT count(*) FROM astyanaxunittests.standard1 where KEY='A';").execute();
        long count = ((CqlResult)result.getResult()).getNumber();
        LOG.info((Object)("CQL Count: " + count));
        Assert.assertTrue((0L <= count ? 1 : 0) != 0);
    }

    @Test
    public void testGetSingleColumn() throws Exception {
        keyspace.prepareColumnMutation(CF_STANDARD1, (Object)"A", (Object)"a").putValue(1, null).execute();
        Column column = (Column)keyspace.prepareQuery(CF_STANDARD1).getRow((Object)"A").getColumn((Object)"a").execute().getResult();
        Assert.assertNotNull((Object)column);
        Assert.assertEquals((int)1, (int)column.getIntegerValue());
    }

    @Test
    public void testGetSingleKeyNotExists() throws Exception {
        Column column = (Column)keyspace.prepareQuery(CF_STANDARD1).getRow((Object)"AA").getColumn((Object)"ab").execute().getResult();
        Assert.assertNull((Object)column);
    }

    @Test
    public void testFunctionalQuery() throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String rowKey = Character.toString(keyName);
            ColumnListMutation cfmStandard = m.withRow(CF_STANDARD1, (Object)rowKey);
            for (char cName = 'a'; cName <= 'z'; cName = (char)(cName + '\u0001')) {
                cfmStandard.putColumn((Object)Character.toString(cName), cName - 97 + 1, null);
            }
            m.withCaching(true);
            m.execute();
            m.discardMutations();
        }
        OperationResult r1 = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)"A").execute();
        Assert.assertTrue((26 <= ((ColumnList)r1.getResult()).size() ? 1 : 0) != 0);
    }

    @Test
    public void testNullKeyInMutation() throws Exception {
        try {
            keyspace.prepareMutationBatch().withRow(CF_STANDARD1, null).putColumn((Object)"abc", "def");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testColumnSlice() throws ConnectionException {
        OperationResult r1 = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)"A").withColumnSlice((Object[])new String[]{"a", "b"}).execute();
        Assert.assertEquals((int)2, (int)((ColumnList)r1.getResult()).size());
    }

    @Test
    public void testColumnRangeSlice() throws ConnectionException {
        OperationResult r1 = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)"A").withColumnRange(new RangeBuilder().setStart("a").setEnd("b").setLimit(5).build()).execute();
        Assert.assertEquals((int)2, (int)((ColumnList)r1.getResult()).size());
        OperationResult r2 = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)"A").withColumnRange((Object)"a", null, false, 5).execute();
        Assert.assertEquals((int)5, (int)((ColumnList)r2.getResult()).size());
        Assert.assertEquals((String)"a", (String)((String)((ColumnList)r2.getResult()).getColumnByIndex(0).getName()));
        ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
        OperationResult r3 = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)"A").withColumnRange(EMPTY_BUFFER, EMPTY_BUFFER, true, 5).execute();
        Assert.assertEquals((int)5, (int)((ColumnList)r3.getResult()).size());
        Assert.assertEquals((String)"z", (String)((String)((ColumnList)r3.getResult()).getColumnByIndex(0).getName()));
    }

    @Test
    public void testGetSingleColumnNotExists() throws ConnectionException {
        Column column = (Column)keyspace.prepareQuery(CF_STANDARD1).getRow((Object)"A").getColumn((Object)"DoesNotExist").execute().getResult();
        Assert.assertNull((Object)column);
    }

    @Test
    public void testGetSingleColumnNotExistsAsync() {
        Future future = null;
        try {
            future = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)"A").getColumn((Object)"DoesNotExist").executeAsync();
            future.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ConnectionException e) {
            LOG.info((Object)("ConnectionException: " + e.getMessage()));
            Assert.fail();
        }
        catch (InterruptedException e) {
            LOG.info((Object)e.getMessage());
            Assert.fail();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NotFoundException) {
                LOG.info((Object)e.getCause().getMessage());
            } else {
                Assert.fail((String)e.getMessage());
            }
        }
        catch (TimeoutException e) {
            future.cancel(true);
            LOG.info((Object)e.getMessage());
            Assert.fail();
        }
    }

    @Test
    public void testGetSingleKey() throws ConnectionException {
        for (char key = 'A'; key <= 'Z'; key = (char)(key + '\u0001')) {
            String keyName = Character.toString(key);
            OperationResult result = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)keyName).execute();
            Assert.assertNotNull((Object)result.getResult());
            Assert.assertFalse((boolean)((ColumnList)result.getResult()).isEmpty());
        }
    }

    @Test
    public void testGetSingleKeyAsync() throws Exception {
        ListenableFuture future = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)"A").executeAsync();
        ColumnList result = (ColumnList)((OperationResult)future.get(1000L, TimeUnit.MILLISECONDS)).getResult();
        Assert.assertFalse((boolean)result.isEmpty());
    }

    @Test
    public void testGetAllKeysRoot() throws ConnectionException {
        LOG.info((Object)"Starting testGetAllKeysRoot...");
        ArrayList<String> keys = new ArrayList<String>();
        for (char key = 'A'; key <= 'Z'; key = (char)(key + '\u0001')) {
            String keyName = Character.toString(key);
            keys.add(keyName);
        }
        OperationResult result = keyspace.prepareQuery(CF_STANDARD1).getKeySlice((Object[])keys.toArray(new String[keys.size()])).execute();
        Assert.assertEquals((int)26, (int)((Rows)result.getResult()).size());
        Row row = ((Rows)result.getResult()).getRow((Object)"A");
        Assert.assertEquals((String)"A", (String)((String)row.getKey()));
        row = ((Rows)result.getResult()).getRow((Object)"B");
        Assert.assertEquals((String)"B", (String)((String)row.getKey()));
        row = ((Rows)result.getResult()).getRow((Object)"NonExistent");
        Assert.assertNull((Object)row);
        row = ((Rows)result.getResult()).getRowByIndex(10);
        Assert.assertEquals((String)"K", (String)((String)row.getKey()));
        LOG.info((Object)"... testGetAllKeysRoot");
    }

    @Test
    public void testEmptyRowKey() {
        try {
            keyspace.prepareMutationBatch().withRow(CF_STANDARD1, (Object)"");
            Assert.fail();
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            keyspace.prepareMutationBatch().withRow(CF_STANDARD1, null);
            Assert.fail();
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
    }

    @Test
    public void testGetColumnSlice() throws ConnectionException {
        LOG.info((Object)"Starting testGetColumnSlice...");
        OperationResult result = keyspace.prepareQuery(CF_STANDARD1).getKey((Object)"A").withColumnSlice(new ColumnSlice((Object)"c", (Object)"h").setLimit(5)).execute();
        Assert.assertNotNull((Object)result.getResult());
        Assert.assertEquals((int)5, (int)((ColumnList)result.getResult()).size());
    }

    @Test
    public void testGetAllKeysPath() throws ConnectionException {
        LOG.info((Object)"Starting testGetAllKeysPath...");
        ArrayList<String> keys = new ArrayList<String>();
        for (char key = 'A'; key <= 'Z'; key = (char)(key + '\u0001')) {
            String keyName = Character.toString(key);
            keys.add(keyName);
        }
        OperationResult result = keyspace.prepareQuery(CF_STANDARD1).getKeySlice((Object[])keys.toArray(new String[keys.size()])).execute();
        for (Row row : (Rows)result.getResult()) {
            System.out.println(row.getColumns().size());
        }
        OperationResult counts = keyspace.prepareQuery(CF_STANDARD1).getKeySlice((Object[])keys.toArray(new String[keys.size()])).getColumnCounts().execute();
        Assert.assertEquals((int)26, (int)((Map)counts.getResult()).size());
        for (Map.Entry count : ((Map)counts.getResult()).entrySet()) {
            Assert.assertEquals((Object)new Integer(26), count.getValue());
        }
        LOG.info((Object)"Starting testGetAllKeysPath...");
    }

    @Test
    public void testHasValue() throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        m.withRow(CF_USER_INFO, (Object)"acct1234").putColumn((Object)"firstname", "john", null).putColumn((Object)"lastname", "smith", null).putColumn((Object)"address", "555 Elm St", null).putColumn((Object)"age", 30, null).putEmptyColumn((Object)"empty");
        m.execute();
        ColumnList response = (ColumnList)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)"acct1234").execute().getResult();
        Assert.assertEquals((String)"firstname", (String)((String)response.getColumnByName((Object)"firstname").getName()));
        Assert.assertEquals((String)"firstname", (String)((String)response.getColumnByName((Object)"firstname").getName()));
        Assert.assertEquals((String)"john", (String)response.getColumnByName((Object)"firstname").getStringValue());
        Assert.assertEquals((String)"john", (String)response.getColumnByName((Object)"firstname").getStringValue());
        Assert.assertEquals((boolean)true, (boolean)response.getColumnByName((Object)"firstname").hasValue());
        Assert.assertEquals((boolean)false, (boolean)response.getColumnByName((Object)"empty").hasValue());
    }

    @Test
    public void testDelete() throws Exception {
        LOG.info((Object)"Starting testDelete...");
        String rowKey = "DeleteMe_testDelete";
        MutationBatch m = keyspace.prepareMutationBatch();
        m.withRow(CF_STANDARD1, (Object)rowKey).putColumn((Object)"Column1", "X", null).putColumn((Object)"Column2", "X", null);
        m.execute();
        Column column = (Column)keyspace.prepareQuery(CF_STANDARD1).getRow((Object)rowKey).getColumn((Object)"Column1").execute().getResult();
        Assert.assertEquals((String)"X", (String)column.getStringValue());
        m = keyspace.prepareMutationBatch();
        m.withRow(CF_STANDARD1, (Object)rowKey).deleteColumn((Object)"Column1");
        m.execute();
        column = (Column)keyspace.prepareQuery(CF_STANDARD1).getRow((Object)rowKey).getColumn((Object)"Column1").execute().getResult();
        Assert.assertNull((Object)column);
        LOG.info((Object)"... testDelete");
    }

    @Test
    public void testDeleteLotsOfColumns() throws Exception {
        ColumnList result;
        LOG.info((Object)"Starting testDelete...");
        String rowKey = "DeleteMe_testDeleteLotsOfColumns";
        int nColumns = 100;
        int pageSize = 25;
        MutationBatch m = keyspace.prepareMutationBatch();
        ColumnListMutation rm = m.withRow(CF_STANDARD1, (Object)rowKey);
        for (int i = 0; i < nColumns; ++i) {
            rm.putEmptyColumn((Object)("" + i), null);
        }
        m.execute();
        int count = (Integer)keyspace.prepareQuery(CF_STANDARD1).setConsistencyLevel(ConsistencyLevel.CL_QUORUM).getKey((Object)rowKey).getCount().execute().getResult();
        Assert.assertEquals((int)nColumns, (int)count);
        m = keyspace.prepareMutationBatch().setConsistencyLevel(ConsistencyLevel.CL_QUORUM);
        rm = m.withRow(CF_STANDARD1, (Object)rowKey);
        for (int i = 0; i < nColumns / 2; ++i) {
            rm.deleteColumn((Object)("" + i));
        }
        m.execute();
        count = (Integer)keyspace.prepareQuery(CF_STANDARD1).setConsistencyLevel(ConsistencyLevel.CL_QUORUM).getKey((Object)rowKey).getCount().execute().getResult();
        Assert.assertEquals((int)(nColumns / 2), (int)count);
        RowQuery query = keyspace.prepareQuery(CF_STANDARD1).setConsistencyLevel(ConsistencyLevel.CL_QUORUM).getKey((Object)rowKey).withColumnRange(new RangeBuilder().setLimit(pageSize).build()).autoPaginate(true);
        count = 0;
        while (!(result = (ColumnList)query.execute().getResult()).isEmpty()) {
            count += result.size();
        }
        Assert.assertEquals((int)(nColumns / 2), (int)count);
        m = keyspace.prepareMutationBatch().setConsistencyLevel(ConsistencyLevel.CL_QUORUM);
        rm = m.withRow(CF_STANDARD1, (Object)rowKey);
        for (int i = 0; i < nColumns; ++i) {
            rm.deleteColumn((Object)("" + i));
        }
        m.execute();
        count = (Integer)keyspace.prepareQuery(CF_STANDARD1).setConsistencyLevel(ConsistencyLevel.CL_QUORUM).getKey((Object)rowKey).getCount().execute().getResult();
        Assert.assertEquals((int)0, (int)count);
        LOG.info((Object)"... testDelete");
    }

    @Test
    public void testCopy() throws ConnectionException {
        String keyName = "A";
        keyspace.prepareQuery(CF_STANDARD1).getKey((Object)keyName).copyTo(CF_STANDARD2, (Object)keyName).execute();
        ColumnList list1 = (ColumnList)keyspace.prepareQuery(CF_STANDARD1).getKey((Object)keyName).execute().getResult();
        ColumnList list2 = (ColumnList)keyspace.prepareQuery(CF_STANDARD2).getKey((Object)keyName).execute().getResult();
        Iterator iter1 = list1.iterator();
        Iterator iter2 = list2.iterator();
        while (iter1.hasNext()) {
            Column column1 = (Column)iter1.next();
            Column column2 = (Column)iter2.next();
            Assert.assertEquals((String)((String)column1.getName()), (String)((String)column2.getName()));
            Assert.assertEquals((Object)column1.getByteBufferValue(), (Object)column2.getByteBufferValue());
        }
        Assert.assertFalse((boolean)iter2.hasNext());
    }

    @Test
    public void testMutationMerge() throws Exception {
        MutationBatch m1 = keyspace.prepareMutationBatch();
        MutationBatch m2 = keyspace.prepareMutationBatch();
        MutationBatch m3 = keyspace.prepareMutationBatch();
        MutationBatch m4 = keyspace.prepareMutationBatch();
        MutationBatch m5 = keyspace.prepareMutationBatch();
        m1.withRow(CF_STANDARD1, (Object)"1").putColumn((Object)"1", "X", null);
        m2.withRow(CF_STANDARD1, (Object)"2").putColumn((Object)"2", "X", null).putColumn((Object)"3", "X", null);
        m3.withRow(CF_STANDARD1, (Object)"3").putColumn((Object)"4", "X", null).putColumn((Object)"5", "X", null).putColumn((Object)"6", "X", null);
        m4.withRow(CF_STANDARD1, (Object)"1").putColumn((Object)"7", "X", null).putColumn((Object)"8", "X", null).putColumn((Object)"9", "X", null).putColumn((Object)"10", "X", null);
        MutationBatch merged = keyspace.prepareMutationBatch();
        Assert.assertEquals((int)merged.getRowCount(), (int)0);
        merged.mergeShallow(m1);
        Assert.assertEquals((int)merged.getRowCount(), (int)1);
        merged.mergeShallow(m2);
        Assert.assertEquals((int)merged.getRowCount(), (int)2);
        merged.mergeShallow(m3);
        Assert.assertEquals((int)merged.getRowCount(), (int)3);
        merged.mergeShallow(m4);
        Assert.assertEquals((int)merged.getRowCount(), (int)3);
        merged.mergeShallow(m5);
        Assert.assertEquals((int)merged.getRowCount(), (int)3);
        merged.execute();
        Rows result = (Rows)keyspace.prepareQuery(CF_STANDARD1).getRowSlice((Object[])new String[]{"1", "2", "3"}).execute().getResult();
        Assert.assertTrue((5 == result.getRow((Object)"1").getColumns().size() ? 1 : 0) != 0);
        Assert.assertTrue((2 == result.getRow((Object)"2").getColumns().size() ? 1 : 0) != 0);
        Assert.assertTrue((3 == result.getRow((Object)"3").getColumns().size() ? 1 : 0) != 0);
    }

    public static class UserInfo
    implements Serializable {
        private static final long serialVersionUID = 6366200973810770033L;
        private String firstName;
        private String lastName;

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public boolean equals(Object other) {
            UserInfo smo = (UserInfo)other;
            return this.firstName.equals(smo.firstName) && this.lastName.equals(smo.lastName);
        }
    }
}

