/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.annotations.Component;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.serializers.AnnotatedCompositeSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class CompositeColumnTests
extends KeyspaceTests {
    private static AnnotatedCompositeSerializer<Population> compSerializer = new AnnotatedCompositeSerializer(Population.class);
    private static ColumnFamily<Integer, Population> CF_POPULATION = new ColumnFamily("population", (Serializer)IntegerSerializer.get(), compSerializer, (Serializer)IntegerSerializer.get());
    public static Population NewYork = new Population("NY", "New York", 10000);
    public static Population SanDiego = new Population("CA", "San Diego", 20000);
    public static Population SanFrancisco = new Population("CA", "San Francisco", 30000);
    public static Population Seattle = new Population("WA", "Seattle", 40000);

    @BeforeClass
    public static void init() throws Exception {
        CompositeColumnTests.initContext();
        keyspace.createColumnFamily(CF_POPULATION, null);
        CF_POPULATION.describe(keyspace);
    }

    @AfterClass
    public static void teardown() throws Exception {
        keyspace.dropColumnFamily(CF_POPULATION);
    }

    @Test
    public void runAllTests() throws Exception {
        boolean rowDeleted = false;
        this.populateRowsForCFPopulation();
        Thread.sleep(1000L);
        this.testReadSingleRowAllColumns(rowDeleted);
        this.testReadSingleRowSingleColumn(rowDeleted);
        this.testReadSingleRowColumnRange(rowDeleted);
        this.testReadMultipleRowKeysWithAllColumns(rowDeleted);
        this.testReadMultipleRowKeysWithColumnRange(rowDeleted);
        this.testReadRowRangeWithAllColumns(rowDeleted);
        this.testReadRowRangeWithColumnRange(rowDeleted);
        this.testReadSingleRowAllColumnsWithColumnCount(rowDeleted);
        this.testReadSingleRowColumnRangeWithColumnCount(rowDeleted);
        this.testReadMultipleRowKeysAllColumnsWithColumnCount(rowDeleted);
        this.testReadMultipleRowKeysColumnRangeWithColumnCount(rowDeleted);
        this.testReadRowRangeAllColumnsWithColumnCount(rowDeleted);
        this.testReadRowRangeColumnRangeWithColumnCount(rowDeleted);
        this.deleteRowsForCFPopulation();
        Thread.sleep(1000L);
        rowDeleted = true;
        this.testReadSingleRowAllColumns(rowDeleted);
        this.testReadSingleRowSingleColumn(rowDeleted);
        this.testReadSingleRowColumnRange(rowDeleted);
        this.testReadMultipleRowKeysWithAllColumns(rowDeleted);
        this.testReadMultipleRowKeysWithColumnRange(rowDeleted);
        this.testReadRowRangeWithAllColumns(rowDeleted);
        this.testReadRowRangeWithColumnRange(rowDeleted);
        this.testReadSingleRowAllColumnsWithColumnCount(rowDeleted);
        this.testReadSingleRowColumnRangeWithColumnCount(rowDeleted);
        this.testReadMultipleRowKeysAllColumnsWithColumnCount(rowDeleted);
        this.testReadMultipleRowKeysColumnRangeWithColumnCount(rowDeleted);
        this.testReadRowRangeAllColumnsWithColumnCount(rowDeleted);
        this.testReadRowRangeColumnRangeWithColumnCount(rowDeleted);
    }

    private void populateRowsForCFPopulation() throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        Random random = new Random();
        for (int year = 2001; year <= 2014; ++year) {
            m.withRow(CF_POPULATION, (Object)year).putColumn((Object)NewYork.clone(), random.nextInt(25000)).putColumn((Object)SanDiego.clone(), random.nextInt(25000)).putColumn((Object)SanFrancisco.clone(), random.nextInt(25000)).putColumn((Object)Seattle.clone(), random.nextInt(25000));
        }
        m.execute();
    }

    private void deleteRowsForCFPopulation() throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        for (int year = 2001; year <= 2014; ++year) {
            m.withRow(CF_POPULATION, (Object)year).delete();
        }
        m.execute();
    }

    private void testReadSingleRowAllColumns(boolean rowDeleted) throws Exception {
        for (int year = 2001; year <= 2014; ++year) {
            ColumnList result = (ColumnList)keyspace.prepareQuery(CF_POPULATION).getRow((Object)year).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)result.isEmpty());
                continue;
            }
            this.checkResult((ColumnList<Population>)result, SanDiego, SanFrancisco, NewYork, Seattle);
        }
    }

    private void testReadSingleRowSingleColumn(boolean rowDeleted) throws Exception {
        for (int year = 2001; year <= 2014; ++year) {
            Column result = (Column)keyspace.prepareQuery(CF_POPULATION).getRow((Object)year).getColumn((Object)SanFrancisco.clone()).execute().getResult();
            if (rowDeleted) {
                Assert.assertNull((Object)result);
                continue;
            }
            Assert.assertTrue((boolean)result.hasValue());
            Assert.assertEquals((Object)SanFrancisco, (Object)result.getName());
        }
    }

    private void testReadSingleRowColumnRange(boolean rowDeleted) throws Exception {
        AnnotatedCompositeSerializer compSerializer = new AnnotatedCompositeSerializer(Population.class);
        for (int year = 2001; year <= 2001; ++year) {
            ColumnList result = (ColumnList)keyspace.prepareQuery(CF_POPULATION).getRow((Object)year).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").build()).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)result.isEmpty());
                continue;
            }
            this.checkResult((ColumnList<Population>)result, SanDiego, SanFrancisco);
            result = (ColumnList)keyspace.prepareQuery(CF_POPULATION).getRow((Object)year).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").greaterThan((Object)"San Diego").build()).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)result.isEmpty());
                continue;
            }
            this.checkResult((ColumnList<Population>)result, SanFrancisco);
            result = (ColumnList)keyspace.prepareQuery(CF_POPULATION).getRow((Object)year).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"WA").withPrefix((Object)"Seattle").withPrefix((Object)40000).build()).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)result.isEmpty());
                continue;
            }
            this.checkResult((ColumnList<Population>)result, Seattle);
        }
    }

    private void testReadMultipleRowKeysWithAllColumns(boolean rowDeleted) throws Exception {
        Rows result = (Rows)keyspace.prepareQuery(CF_POPULATION).getKeySlice((Object[])new Integer[]{2001, 2002, 2003, 2004, 2005}).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            this.checkRowResult((Rows<Integer, Population>)result, 2001, 5, SanDiego, SanFrancisco, NewYork, Seattle);
        }
    }

    private void testReadMultipleRowKeysWithColumnRange(boolean rowDeleted) throws Exception {
        Rows result = (Rows)keyspace.prepareQuery(CF_POPULATION).getKeySlice((Object[])new Integer[]{2001, 2002, 2003, 2004, 2005}).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").build()).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            this.checkRowResult((Rows<Integer, Population>)result, 2001, 5, SanDiego, SanFrancisco);
        }
        result = (Rows)keyspace.prepareQuery(CF_POPULATION).getKeySlice((Object[])new Integer[]{2001, 2002, 2003, 2004, 2005}).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").greaterThan((Object)"San Diego").build()).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            this.checkRowResult((Rows<Integer, Population>)result, 2001, 5, SanFrancisco);
        }
        result = (Rows)keyspace.prepareQuery(CF_POPULATION).getKeySlice((Object[])new Integer[]{2001, 2002, 2003, 2004, 2005}).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"WA").withPrefix((Object)"Seattle").withPrefix((Object)40000).build()).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)result.isEmpty());
        } else {
            this.checkRowResult((Rows<Integer, Population>)result, 2001, 5, Seattle);
        }
    }

    private void testReadRowRangeWithAllColumns(boolean rowDeleted) throws Exception {
        List<TestRange> testRanges = this.getTestRanges();
        for (TestRange testRange : testRanges) {
            Rows result = (Rows)keyspace.prepareQuery(CF_POPULATION).getKeyRange(null, null, testRange.start, testRange.end, 100).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)result.isEmpty());
                continue;
            }
            this.checkRowResult((Rows<Integer, Population>)result, testRange.expectedRowKeys, SanDiego, SanFrancisco, NewYork, Seattle);
        }
    }

    private void testReadRowRangeWithColumnRange(boolean rowDeleted) throws Exception {
        List<TestRange> testRanges = this.getTestRanges();
        for (TestRange testRange : testRanges) {
            Rows result = (Rows)keyspace.prepareQuery(CF_POPULATION).getKeyRange(null, null, testRange.start, testRange.end, 100).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").build()).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)result.isEmpty());
            } else {
                this.checkRowResult((Rows<Integer, Population>)result, testRange.expectedRowKeys, SanDiego, SanFrancisco);
            }
            result = (Rows)keyspace.prepareQuery(CF_POPULATION).getKeyRange(null, null, testRange.start, testRange.end, 100).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").greaterThan((Object)"San Diego").build()).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)result.isEmpty());
            } else {
                this.checkRowResult((Rows<Integer, Population>)result, testRange.expectedRowKeys, SanFrancisco);
            }
            result = (Rows)keyspace.prepareQuery(CF_POPULATION).getKeyRange(null, null, testRange.start, testRange.end, 100).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"WA").withPrefix((Object)"Seattle").withPrefix((Object)40000).build()).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)result.isEmpty());
                continue;
            }
            this.checkRowResult((Rows<Integer, Population>)result, testRange.expectedRowKeys, Seattle);
        }
    }

    private void testReadSingleRowAllColumnsWithColumnCount(boolean rowDeleted) throws Exception {
        for (int year = 2001; year <= 2014; ++year) {
            Integer result = (Integer)keyspace.prepareQuery(CF_POPULATION).getRow((Object)year).getCount().execute().getResult();
            int expected = rowDeleted ? 0 : 4;
            Assert.assertTrue((expected == result ? 1 : 0) != 0);
        }
    }

    private void testReadSingleRowColumnRangeWithColumnCount(boolean rowDeleted) throws Exception {
        for (int year = 2001; year <= 2014; ++year) {
            Integer result = (Integer)keyspace.prepareQuery(CF_POPULATION).getRow((Object)year).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").build()).getCount().execute().getResult();
            int expected = rowDeleted ? 0 : 2;
            Assert.assertTrue((expected == result ? 1 : 0) != 0);
            result = (Integer)keyspace.prepareQuery(CF_POPULATION).getRow((Object)year).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").greaterThan((Object)"San Diego").build()).getCount().execute().getResult();
            expected = rowDeleted ? 0 : 1;
            Assert.assertTrue((expected == result ? 1 : 0) != 0);
            result = (Integer)keyspace.prepareQuery(CF_POPULATION).getRow((Object)year).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"WA").withPrefix((Object)"Seattle").withPrefix((Object)40000).build()).getCount().execute().getResult();
            expected = rowDeleted ? 0 : 1;
            Assert.assertTrue((expected == result ? 1 : 0) != 0);
        }
    }

    private void testReadMultipleRowKeysAllColumnsWithColumnCount(boolean rowDeleted) throws Exception {
        Map result = (Map)keyspace.prepareQuery(CF_POPULATION).getKeySlice((Object[])new Integer[]{2001, 2002, 2003, 2004, 2005}).getColumnCounts().execute().getResult();
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        if (!rowDeleted) {
            for (int year = 2001; year <= 2005; ++year) {
                expected.put(year, 4);
            }
        }
        Assert.assertEquals(expected, (Object)result);
    }

    private void testReadMultipleRowKeysColumnRangeWithColumnCount(boolean rowDeleted) throws Exception {
        Integer n;
        Integer n2;
        Integer rowKey;
        Map result = (Map)keyspace.prepareQuery(CF_POPULATION).getKeySlice((Object[])new Integer[]{2001, 2002, 2003, 2004, 2005}).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").build()).getColumnCounts().execute().getResult();
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        if (!rowDeleted) {
            rowKey = 2001;
            while (rowKey <= 2005) {
                expected.put(rowKey, 2);
                n2 = rowKey;
                n = rowKey = Integer.valueOf(rowKey + 1);
            }
        }
        Assert.assertEquals(expected, (Object)result);
        result = (Map)keyspace.prepareQuery(CF_POPULATION).getKeySlice((Object[])new Integer[]{2001, 2002, 2003, 2004, 2005}).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").greaterThan((Object)"San Diego").build()).getColumnCounts().execute().getResult();
        expected = new HashMap();
        if (!rowDeleted) {
            rowKey = 2001;
            while (rowKey <= 2005) {
                expected.put(rowKey, 1);
                n2 = rowKey;
                n = rowKey = Integer.valueOf(rowKey + 1);
            }
        }
        Assert.assertEquals(expected, (Object)result);
        result = (Map)keyspace.prepareQuery(CF_POPULATION).getKeySlice((Object[])new Integer[]{2001, 2002, 2003, 2004, 2005}).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"WA").withPrefix((Object)"Seattle").withPrefix((Object)40000).build()).getColumnCounts().execute().getResult();
        expected = new HashMap();
        if (!rowDeleted) {
            rowKey = 2001;
            while (rowKey <= 2005) {
                expected.put(rowKey, 1);
                n2 = rowKey;
                n = rowKey = Integer.valueOf(rowKey + 1);
            }
        }
        Assert.assertEquals(expected, (Object)result);
    }

    private void testReadRowRangeAllColumnsWithColumnCount(boolean rowDeleted) throws Exception {
        List<TestRange> testRanges = this.getTestRanges();
        TestRange range = testRanges.get(0);
        Map result = (Map)keyspace.prepareQuery(CF_POPULATION).getKeyRange(null, null, range.start, range.end, 100).getColumnCounts().execute().getResult();
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        if (!rowDeleted) {
            for (Integer year : range.expectedRowKeys) {
                expected.put(year, 4);
            }
        }
        Assert.assertEquals(expected, (Object)result);
    }

    private void testReadRowRangeColumnRangeWithColumnCount(boolean rowDeleted) throws Exception {
        List<TestRange> testRanges = this.getTestRanges();
        for (TestRange testRange : testRanges) {
            Map result = (Map)keyspace.prepareQuery(CF_POPULATION).getKeyRange(null, null, testRange.start, testRange.end, 100).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").build()).getColumnCounts().execute().getResult();
            HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
            if (!rowDeleted) {
                for (Integer rowKey : testRange.expectedRowKeys) {
                    expected.put(rowKey, 2);
                }
            }
            Assert.assertEquals(expected, (Object)result);
            result = (Map)keyspace.prepareQuery(CF_POPULATION).getKeyRange(null, null, testRange.start, testRange.end, 100).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"CA").greaterThan((Object)"San Diego").build()).getColumnCounts().execute().getResult();
            expected = new HashMap();
            if (!rowDeleted) {
                for (Integer rowKey : testRange.expectedRowKeys) {
                    expected.put(rowKey, 1);
                }
            }
            Assert.assertEquals(expected, (Object)result);
            result = (Map)keyspace.prepareQuery(CF_POPULATION).getKeyRange(null, null, testRange.start, testRange.end, 100).withColumnRange((ByteBufferRange)compSerializer.buildRange().withPrefix((Object)"WA").withPrefix((Object)"Seattle").withPrefix((Object)40000).build()).getColumnCounts().execute().getResult();
            expected = new HashMap();
            if (!rowDeleted) {
                for (Integer rowKey : testRange.expectedRowKeys) {
                    expected.put(rowKey, 1);
                }
            }
            Assert.assertEquals(expected, (Object)result);
        }
    }

    private void checkResult(ColumnList<Population> result, Population ... expected) throws Exception {
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)expected.length, (int)result.size());
        int index = 0;
        for (Population p : expected) {
            Assert.assertEquals((Object)p, (Object)result.getColumnByIndex(index++).getName());
        }
    }

    private void checkRowResult(Rows<Integer, Population> result, Integer startKey, Integer size, Population ... expected) throws Exception {
        int rowKey = startKey;
        for (Row row : result) {
            Assert.assertTrue((rowKey == (Integer)row.getKey() ? 1 : 0) != 0);
            this.checkResult((ColumnList<Population>)row.getColumns(), expected);
            ++rowKey;
        }
        Assert.assertTrue((String)("Result: " + result.size() + ", size: " + size), (size.intValue() == result.size() ? 1 : 0) != 0);
    }

    private void checkRowResult(Rows<Integer, Population> result, List<Integer> rowKeys, Population ... expected) throws Exception {
        int index = 0;
        for (Row row : result) {
            Assert.assertEquals((String)(rowKeys.toString() + " " + row.getKey()), (Object)rowKeys.get(index++), (Object)row.getKey());
            this.checkResult((ColumnList<Population>)row.getColumns(), expected);
        }
        Assert.assertTrue((rowKeys.size() == result.size() ? 1 : 0) != 0);
    }

    private List<TestRange> getTestRanges() {
        ArrayList<TestRange> list = new ArrayList<TestRange>();
        list.add(new TestRange("-6625834866172541556", "-4850296245464368619", new Integer[]{2014, 2003, 2009}));
        list.add(new TestRange("-4012971246572234480", "-3604768136712843506", new Integer[]{2010, 2005, 2006}));
        list.add(new TestRange("-3193851331505022123", "267648259961407629", new Integer[]{2012, 2007, 2001}));
        list.add(new TestRange("313927025611477591", "5455601112738248795", new Integer[]{2002, 2011, 2004}));
        list.add(new TestRange("8821734684824899422", "9033513988054576353", new Integer[]{2013, 2008}));
        return list;
    }

    private static class TestRange {
        private String start;
        private String end;
        private List<Integer> expectedRowKeys = new ArrayList<Integer>();

        private TestRange(String start, String end, Integer ... rows) {
            this.start = start;
            this.end = end;
            this.expectedRowKeys.addAll(Arrays.asList(rows));
        }
    }

    public static class Population {
        @Component(ordinal=0)
        String state;
        @Component(ordinal=1)
        String city;
        @Component(ordinal=2)
        Integer zipcode;

        public Population() {
        }

        public Population(String state, String city, Integer zipcode) {
            this.state = state;
            this.city = city;
            this.zipcode = zipcode;
        }

        public String toString() {
            return "Population [" + this.state + ", " + this.city + ", " + this.zipcode + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            result = 31 * result + (this.city == null ? 0 : this.city.hashCode());
            result = 31 * result + (this.zipcode == null ? 0 : this.zipcode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Population other = (Population)obj;
            boolean equal = true;
            equal &= this.state != null ? this.state.equals(other.state) : other.state == null;
            equal &= this.city != null ? this.city.equals(other.city) : other.city == null;
            return equal &= this.zipcode != null ? this.zipcode.equals(other.zipcode) : other.zipcode == null;
        }

        public Population clone() {
            return new Population(this.state, this.city, this.zipcode);
        }
    }
}

