/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.reads.model.CqlRangeBuilder;
import com.netflix.astyanax.cql.test.utils.ReadTests;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.partitioner.Murmur3Partitioner;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.Date;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class PreparedStatementTests
extends ReadTests {
    private static int TestRowCount = 10;
    private static ColumnFamily<String, String> CF_ROW_RANGE = new ColumnFamily("rowrange", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)IntegerSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        PreparedStatementTests.initContext();
        keyspace.createColumnFamily(CF_USER_INFO, null);
        keyspace.createColumnFamily(CF_ROW_RANGE, null);
        CF_USER_INFO.describe(keyspace);
        CF_ROW_RANGE.describe(keyspace);
        PreparedStatementTests.populateRowsForUserInfo(TestRowCount);
        PreparedStatementTests.populateRowsForColumnRange();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_USER_INFO);
        keyspace.dropColumnFamily(CF_ROW_RANGE);
    }

    @Test
    public void testSingleRowAllColumnsQuery() throws Exception {
        for (int i = 0; i < TestRowCount; ++i) {
            ColumnList result = (ColumnList)keyspace.prepareQuery(CF_USER_INFO).withCaching(true).getRow((Object)("acct_" + i)).execute().getResult();
            super.testAllColumnsForRow((ColumnList<String>)result, i);
        }
    }

    @Test
    public void testSingleRowSingleColumnQuery() throws Exception {
        for (int i = 0; i < TestRowCount; ++i) {
            Column result = (Column)keyspace.prepareQuery(CF_USER_INFO).withCaching(true).getRow((Object)("acct_" + i)).getColumn((Object)"address").execute().getResult();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((String)"address", (String)((String)result.getName()));
            Assert.assertNotNull((Object)result.getStringValue());
            Assert.assertEquals((String)("john smith address " + i), (String)result.getStringValue());
        }
    }

    @Test
    public void testSingleRowColumnSliceQueryWithCollection() throws Exception {
        for (int i = 0; i < TestRowCount; ++i) {
            ColumnList result = (ColumnList)keyspace.prepareQuery(CF_USER_INFO).withCaching(true).getRow((Object)("acct_" + i)).withColumnSlice((Object[])new String[]{"firstname", "lastname", "address", "age"}).execute().getResult();
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((4 == result.size() ? 1 : 0) != 0);
            Assert.assertEquals((String)("john_" + i), (String)result.getColumnByName((Object)"firstname").getStringValue());
            Assert.assertEquals((String)("smith_" + i), (String)result.getColumnByName((Object)"lastname").getStringValue());
            Assert.assertEquals((String)("john smith address " + i), (String)result.getColumnByName((Object)"address").getStringValue());
            Assert.assertTrue((30 + i == result.getColumnByName((Object)"age").getIntegerValue() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRowKeysAllColumnsQuery() throws Exception {
        keyspace.prepareQuery(CF_USER_INFO).withCaching(true).getRowSlice((Object[])new String[]{"acct_0", "acct_1", "acct_2", "acct_3"}).execute();
        Rows result = (Rows)keyspace.prepareQuery(CF_USER_INFO).withCaching(true).getRowSlice((Object[])new String[]{"acct_4", "acct_5", "acct_6", "acct_7"}).execute().getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((4 == result.size() ? 1 : 0) != 0);
        for (Row row : result) {
            int rowNo = Integer.parseInt(((String)row.getKey()).substring("acct_".length()));
            Assert.assertTrue((rowNo >= 4 ? 1 : 0) != 0);
            Assert.assertTrue((rowNo <= 7 ? 1 : 0) != 0);
            Assert.assertTrue((13 == row.getColumns().size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRowKeysColumnSetQuery() throws Exception {
        keyspace.prepareQuery(CF_USER_INFO).withCaching(true).getRowSlice((Object[])new String[]{"acct_0", "acct_1", "acct_2", "acct_3"}).withColumnSlice((Object[])new String[]{"firstname", "lastname", "age"}).execute();
        Rows result = (Rows)keyspace.prepareQuery(CF_USER_INFO).withCaching(true).getRowSlice((Object[])new String[]{"acct_4", "acct_5", "acct_6", "acct_7"}).withColumnSlice((Object[])new String[]{"firstname", "lastname", "age"}).execute().getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((4 == result.size() ? 1 : 0) != 0);
        for (Row row : result) {
            int rowNo = Integer.parseInt(((String)row.getKey()).substring("acct_".length()));
            Assert.assertTrue((rowNo >= 4 ? 1 : 0) != 0);
            Assert.assertTrue((rowNo <= 7 ? 1 : 0) != 0);
            Assert.assertTrue((3 == row.getColumns().size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRowKeysColumnRangeQuery() throws Exception {
        keyspace.prepareQuery(CF_ROW_RANGE).withCaching(true).getRowSlice((Object[])new String[]{"A", "B", "C", "D"}).withColumnRange((ByteBufferRange)new CqlRangeBuilder().setStart((Object)"a").setEnd((Object)"c").build()).execute();
        Rows result = (Rows)keyspace.prepareQuery(CF_ROW_RANGE).withCaching(true).getRowSlice((Object[])new String[]{"E", "F", "G", "H"}).withColumnRange((ByteBufferRange)new CqlRangeBuilder().setStart((Object)"d").setEnd((Object)"h").build()).execute().getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((4 == result.size() ? 1 : 0) != 0);
        for (Row row : result) {
            int rowNo = ((String)row.getKey()).charAt(0) - 65;
            Assert.assertTrue((rowNo >= 4 ? 1 : 0) != 0);
            Assert.assertTrue((rowNo <= 7 ? 1 : 0) != 0);
            Assert.assertTrue((5 == row.getColumns().size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRowRangeAllColumnsQuery() throws Exception {
        String startToken = Murmur3Partitioner.get().getTokenForKey(StringSerializer.get().fromString("A"));
        String endToken = Murmur3Partitioner.get().getTokenForKey(StringSerializer.get().fromString("G"));
        keyspace.prepareQuery(CF_ROW_RANGE).withCaching(true).getRowRange(null, null, startToken, endToken, 10).execute();
        Rows result = (Rows)keyspace.prepareQuery(CF_ROW_RANGE).withCaching(true).getRowRange(null, null, startToken, endToken, 10).execute().getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((3 == result.size() ? 1 : 0) != 0);
        for (Row row : result) {
            Assert.assertTrue((26 == row.getColumns().size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRowRangeColumnSetQuery() throws Exception {
        String startToken = Murmur3Partitioner.get().getTokenForKey(StringSerializer.get().fromString("A"));
        String endToken = Murmur3Partitioner.get().getTokenForKey(StringSerializer.get().fromString("G"));
        keyspace.prepareQuery(CF_ROW_RANGE).withCaching(true).getRowRange(null, null, startToken, endToken, 10).withColumnSlice((Object[])new String[]{"a", "s", "d", "f"}).execute();
        Rows result = (Rows)keyspace.prepareQuery(CF_ROW_RANGE).withCaching(true).getRowRange(null, null, startToken, endToken, 10).withColumnSlice((Object[])new String[]{"a", "s", "d", "f"}).execute().getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((3 == result.size() ? 1 : 0) != 0);
        for (Row row : result) {
            Assert.assertTrue((4 == row.getColumns().size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRowRangeColumnRangeQuery() throws Exception {
        String startToken = Murmur3Partitioner.get().getTokenForKey(StringSerializer.get().fromString("A"));
        String endToken = Murmur3Partitioner.get().getTokenForKey(StringSerializer.get().fromString("G"));
        keyspace.prepareQuery(CF_ROW_RANGE).withCaching(true).getRowRange(null, null, startToken, endToken, 10).withColumnRange((ByteBufferRange)new CqlRangeBuilder().setStart((Object)"d").setEnd((Object)"h").build()).execute();
        Rows result = (Rows)keyspace.prepareQuery(CF_ROW_RANGE).withCaching(true).getRowRange(null, null, startToken, endToken, 10).withColumnRange((ByteBufferRange)new CqlRangeBuilder().setStart((Object)"d").setEnd((Object)"h").build()).execute().getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((3 == result.size() ? 1 : 0) != 0);
        for (Row row : result) {
            Assert.assertTrue((5 == row.getColumns().size() ? 1 : 0) != 0);
        }
    }

    private static void populateRowsForUserInfo(int numRows) throws Exception {
        MutationBatch mb = keyspace.prepareMutationBatch();
        for (int i = 0; i < numRows; ++i) {
            Date date = OriginalDate.plusMinutes(i).toDate();
            mb.withRow(CF_USER_INFO, (Object)("acct_" + i)).putColumn((Object)"firstname", "john_" + i, null).putColumn((Object)"lastname", "smith_" + i, null).putColumn((Object)"address", "john smith address " + i, null).putColumn((Object)"age", 30 + i, null).putColumn((Object)"ageShort", new Integer(30 + i).shortValue(), null).putColumn((Object)"ageLong", new Integer(30 + i).longValue(), null).putColumn((Object)"percentile", 30.1).putColumn((Object)"married", true).putColumn((Object)"single", false).putColumn((Object)"birthdate", date).putColumn((Object)"bytes", TestBytes).putColumn((Object)"uuid", TestUUID).putEmptyColumn((Object)"empty");
            mb.execute();
            mb.discardMutations();
        }
    }

    private static void populateRowsForColumnRange() throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String rowKey = Character.toString(keyName);
            ColumnListMutation colMutation = m.withRow(CF_ROW_RANGE, (Object)rowKey);
            for (char cName = 'a'; cName <= 'z'; cName = (char)(cName + '\u0001')) {
                colMutation.putColumn((Object)Character.toString(cName), cName - 97 + 1, null);
            }
            m.withCaching(true);
            m.execute();
            m.discardMutations();
        }
    }
}

