/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test.utils;

import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import junit.framework.Assert;
import org.joda.time.DateTime;

public class ReadTests
extends KeyspaceTests {
    public static DateTime OriginalDate = new DateTime().withMillisOfSecond(0).withSecondOfMinute(0).withMinuteOfHour(0).withHourOfDay(0);
    public static byte[] TestBytes = new String("TestBytes").getBytes();
    public static UUID TestUUID = UUID.fromString("edeb3d70-15ce-11e3-8ffd-0800200c9a66");
    public static String[] columnNamesArr = new String[]{"firstname", "lastname", "address", "age", "ageShort", "ageLong", "percentile", "married", "single", "birthdate", "bytes", "uuid", "empty"};
    public static List<String> columnNames = new ArrayList<String>(Arrays.asList(columnNamesArr));
    public static ColumnFamily<String, String> CF_USER_INFO = ColumnFamily.newColumnFamily((String)"UserInfo", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    public static void initReadTests() throws Exception {
        ReadTests.initContext();
        Collections.sort(columnNames);
    }

    public void testAllColumnsForRow(ColumnList<String> resultColumns, int i) throws Exception {
        Date date = OriginalDate.plusMinutes(i).toDate();
        this.testColumnValue(resultColumns, "firstname", columnNames, "john_" + i);
        this.testColumnValue(resultColumns, "lastname", columnNames, "smith_" + i);
        this.testColumnValue(resultColumns, "address", columnNames, "john smith address " + i);
        this.testColumnValue(resultColumns, "age", columnNames, 30 + i);
        this.testColumnValue(resultColumns, "ageShort", columnNames, new Integer(30 + i).shortValue());
        this.testColumnValue(resultColumns, "ageLong", columnNames, new Integer(30 + i).longValue());
        this.testColumnValue(resultColumns, "percentile", columnNames, 30.1);
        this.testColumnValue(resultColumns, "married", columnNames, true);
        this.testColumnValue(resultColumns, "single", columnNames, false);
        this.testColumnValue(resultColumns, "birthdate", columnNames, date);
        this.testColumnValue(resultColumns, "bytes", columnNames, TestBytes);
        this.testColumnValue(resultColumns, "uuid", columnNames, TestUUID);
        this.testColumnValue(resultColumns, "empty", columnNames, null);
        for (Column col : resultColumns) {
            Assert.assertNotNull((Object)col.getName());
        }
    }

    private <T> void testColumnValue(ColumnList<String> result, String columnName, List<String> columnNames, T expectedValue) {
        Column column = result.getColumnByName((Object)columnName);
        Assert.assertEquals((String)columnName, (String)((String)column.getName()));
        this.testColumnValue((Column<String>)column, expectedValue);
    }

    private <T> void testColumnValue(Column<String> column, T value) {
        if (value != null) {
            Assert.assertTrue((boolean)column.hasValue());
            if (value instanceof String) {
                Assert.assertEquals(value, (Object)column.getStringValue());
            } else if (value instanceof Integer) {
                Assert.assertEquals(value, (Object)column.getIntegerValue());
            } else if (value instanceof Short) {
                Assert.assertEquals(value, (Object)column.getShortValue());
            } else if (value instanceof Long) {
                Assert.assertEquals(value, (Object)column.getLongValue());
            } else if (value instanceof Double) {
                Assert.assertEquals(value, (Object)column.getDoubleValue());
            } else if (value instanceof Boolean) {
                Assert.assertEquals(value, (Object)column.getBooleanValue());
            } else if (value instanceof Date) {
                Assert.assertEquals(value, (Object)column.getDateValue());
            } else if (value instanceof byte[]) {
                ByteBuffer bbuf = column.getByteBufferValue();
                String result = new String(BytesArraySerializer.get().fromByteBuffer(bbuf));
                Assert.assertEquals((String)new String((byte[])value), (String)result);
            } else if (value instanceof UUID) {
                Assert.assertEquals(value, (Object)column.getUUIDValue());
            } else {
                Assert.fail((String)("Value not recognized for column: " + (String)column.getName()));
            }
        } else {
            Assert.assertFalse((boolean)column.hasValue());
        }
    }

    public void populateRows(int numRows) throws Exception {
        MutationBatch mb = keyspace.prepareMutationBatch();
        for (int i = 0; i < numRows; ++i) {
            Date date = OriginalDate.plusMinutes(i).toDate();
            mb.withRow(CF_USER_INFO, (Object)("acct_" + i)).putColumn((Object)"firstname", "john_" + i, null).putColumn((Object)"lastname", "smith_" + i, null).putColumn((Object)"address", "john smith address " + i, null).putColumn((Object)"age", 30 + i, null).putColumn((Object)"ageShort", new Integer(30 + i).shortValue(), null).putColumn((Object)"ageLong", new Integer(30 + i).longValue(), null).putColumn((Object)"percentile", 30.1).putColumn((Object)"married", true).putColumn((Object)"single", false).putColumn((Object)"birthdate", date).putColumn((Object)"bytes", TestBytes).putColumn((Object)"uuid", TestUUID).putEmptyColumn((Object)"empty");
            mb.execute();
            mb.discardMutations();
        }
    }

    public void deleteRows(int numRows) throws Exception {
        MutationBatch mb = keyspace.prepareMutationBatch();
        for (int i = 0; i < numRows; ++i) {
            mb.withRow(CF_USER_INFO, (Object)("acct_" + i)).delete();
            mb.execute();
            mb.discardMutations();
        }
    }

    public Collection<String> getRandomColumns(int numColumns) {
        Random random = new Random();
        HashSet<String> hashSet = new HashSet<String>();
        while (hashSet.size() < numColumns) {
            int pick = random.nextInt(26);
            char ch = (char)(97 + pick);
            hashSet.add(String.valueOf(ch));
        }
        return hashSet;
    }
}

