/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.api.types;

import java.util.Calendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.vremanagement.executor.utils.ObjectCompare;
import org.quartz.CronExpression;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class Scheduling
implements Comparable<Scheduling> {
    @XmlElement
    @JsonProperty
    protected String cronExpression;
    @XmlElement
    @JsonProperty
    protected Integer delay;
    @XmlElement
    @JsonProperty
    protected int schedulingTimes;
    @XmlElement
    @JsonProperty
    protected Long firstStartTime;
    @XmlElement
    @JsonProperty
    protected Long endTime;
    @XmlElement
    @JsonProperty
    protected boolean previuosExecutionsMustBeCompleted;
    @XmlElement
    @JsonProperty
    protected boolean global;

    protected void init(CronExpression cronExpression, Integer delay, int schedulingTimes, Long firstStartTime, Long endTime, boolean previuosExecutionsMustBeCompleted, boolean global) {
        this.cronExpression = cronExpression != null ? cronExpression.getCronExpression() : null;
        this.delay = delay;
        this.schedulingTimes = schedulingTimes;
        this.firstStartTime = firstStartTime;
        this.endTime = endTime;
        this.previuosExecutionsMustBeCompleted = previuosExecutionsMustBeCompleted;
        this.global = global;
    }

    protected Scheduling() {
    }

    public Scheduling(CronExpression cronExpression) {
        this.init(cronExpression, null, 0, null, null, false, false);
    }

    public Scheduling(CronExpression cronExpression, boolean previuosExecutionsMustBeCompleted) {
        this.init(cronExpression, null, 0, null, null, previuosExecutionsMustBeCompleted, false);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes) {
        this.init(cronExpression, null, schedulingTimes, null, null, false, false);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes, boolean previuosExecutionsMustBeCompleted) {
        this.init(cronExpression, null, schedulingTimes, null, null, previuosExecutionsMustBeCompleted, false);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes, Calendar firstStartTime, Calendar endTime) {
        this.init(cronExpression, null, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), false, false);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes, Calendar firstStartTime, Calendar endTime, boolean previuosExecutionsMustBeCompleted) {
        this.init(cronExpression, null, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), previuosExecutionsMustBeCompleted, false);
    }

    public Scheduling(int delay) {
        this.init(null, delay, 0, null, null, false, false);
    }

    public Scheduling(int delay, boolean previuosExecutionsMustBeCompleted) {
        this.init(null, delay, 0, null, null, previuosExecutionsMustBeCompleted, false);
    }

    public Scheduling(int delay, int schedulingTimes) {
        this.init(null, delay, schedulingTimes, null, null, false, false);
    }

    public Scheduling(int delay, int schedulingTimes, boolean previuosExecutionsMustBeCompleted) {
        this.init(null, delay, schedulingTimes, null, null, previuosExecutionsMustBeCompleted, false);
    }

    public Scheduling(int delay, int schedulingTimes, Calendar firstStartTime, Calendar endTime) {
        this.init(null, delay, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), false, false);
    }

    public Scheduling(int delay, int schedulingTimes, Calendar firstStartTime, Calendar endTime, boolean previuosExecutionsMustBeCompleted) {
        this.init(null, delay, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), previuosExecutionsMustBeCompleted, false);
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public int getSchedulingTimes() {
        return this.schedulingTimes;
    }

    public boolean mustPreviousExecutionsCompleted() {
        return this.previuosExecutionsMustBeCompleted;
    }

    public Long getFirstStartTime() {
        return this.firstStartTime;
    }

    public void setFirstStartTime(Long firstStartTime) {
        this.firstStartTime = firstStartTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Boolean getGlobal() {
        return this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public String toString() {
        return String.format("{cronExpression:%s,delay:%d,schedulingTimes:%d,firstStartTime:%d,endTime:%d,previuosExecutionsMustBeCompleted:%b,global:%b}", this.cronExpression, this.delay, this.schedulingTimes, this.firstStartTime, this.endTime, this.previuosExecutionsMustBeCompleted, this.global);
    }

    @Override
    public int compareTo(Scheduling scheduling) {
        int compareResult = 0;
        compareResult = new ObjectCompare<String>().compare(this.cronExpression, scheduling.cronExpression);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Integer>().compare(this.delay, scheduling.delay);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Integer>().compare(new Integer(this.schedulingTimes), new Integer(scheduling.schedulingTimes));
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Long>().compare(this.firstStartTime, scheduling.firstStartTime);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Long>().compare(this.endTime, scheduling.endTime);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Boolean>().compare(new Boolean(this.previuosExecutionsMustBeCompleted), new Boolean(scheduling.previuosExecutionsMustBeCompleted));
        if (compareResult != 0) {
            return compareResult;
        }
        return new ObjectCompare<Boolean>().compare(new Boolean(this.global), new Boolean(scheduling.global));
    }
}

