/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.CountingInputStream;
import com.google.common.io.CountingOutputStream;
import com.netflix.servo.monitor.DynamicCounter;
import com.netflix.servo.publish.BasicMetricFilter;
import com.netflix.servo.publish.CounterToRateMetricTransform;
import com.netflix.servo.publish.FileMetricObserver;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.MonitorRegistryMetricPoller;
import com.netflix.servo.publish.PollRunnable;
import com.netflix.servo.publish.PollScheduler;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoServerExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoServerExample.class);
    public static final int DEFAULT_PORT = 54321;
    private final int port;

    public EchoServerExample(int port) {
        this.port = port;
    }

    public void start() throws IOException {
        AcceptTask task = new AcceptTask(this.port);
        Thread t = new Thread((Runnable)task, "AcceptTask");
        t.start();
    }

    public void shutdown() {
    }

    public static void main(String[] args) throws Exception {
        PollScheduler scheduler = PollScheduler.getInstance();
        scheduler.start();
        int heartbeatInterval = 20;
        CounterToRateMetricTransform transform = new CounterToRateMetricTransform(new FileMetricObserver("serverstat", new File(".")), 20L, TimeUnit.SECONDS);
        PollRunnable task = new PollRunnable((MetricPoller)new MonitorRegistryMetricPoller(), BasicMetricFilter.MATCH_ALL, transform);
        int samplingInterval = 10;
        scheduler.addPoller(task, 10L, TimeUnit.SECONDS);
        int port = 54321;
        if (args.length > 0) {
            port = Integer.valueOf(args[0]);
        }
        EchoServerExample example = new EchoServerExample(port);
        example.start();
    }

    public static class ClientTask
    implements Runnable {
        private final TagList tags;
        private final Socket s;

        public ClientTask(TagList tags, Socket s) {
            this.tags = tags;
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWork() throws IOException {
            CountingInputStream input = null;
            CountingOutputStream output = null;
            try {
                input = new CountingInputStream(this.s.getInputStream());
                output = new CountingOutputStream(this.s.getOutputStream());
                ByteStreams.copy((InputStream)input, (OutputStream)output);
                DynamicCounter.increment("BytesIn", this.tags, input.getCount());
                DynamicCounter.increment("BytesOut", this.tags, output.getCount());
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(input);
                Closeables.closeQuietly(output);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)input);
            Closeables.closeQuietly((Closeable)output);
        }

        @Override
        public void run() {
            try {
                this.doWork();
            }
            catch (IOException e) {
                SocketAddress a = this.s.getRemoteSocketAddress();
                LOGGER.error("failure handling connection from " + a, (Throwable)e);
            }
        }
    }

    public static class AcceptTask
    implements Runnable {
        private static final String[] COUNTRIES = new String[]{"US", "CA", "GB", "IE"};
        private final ServerSocket ss;

        public AcceptTask(int port) throws IOException {
            this.ss = new ServerSocket(port);
        }

        public TagList getTags(Socket s) {
            int length = COUNTRIES.length;
            int countryCode = (s.getInetAddress().hashCode() % length + length) % length;
            String country = COUNTRIES[countryCode];
            return BasicTagList.of("Country", country);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket s = this.ss.accept();
                        TagList tags = this.getTags(s);
                        LOGGER.info("received connection from {} with tags {}", (Object)s.getRemoteSocketAddress(), (Object)tags);
                        DynamicCounter.increment("RequestCount", tags);
                        ClientTask task = new ClientTask(tags, s);
                        Thread t = new Thread((Runnable)task, "ClientTask");
                        t.start();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("failure accepting connection", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

