/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.netflix.astyanax.contrib.dualwrites.FailedWritesLogger;
import com.netflix.astyanax.contrib.dualwrites.WriteMetadata;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBasedFailedWritesLogger
implements FailedWritesLogger {
    private static final Logger Logger = LoggerFactory.getLogger(LogBasedFailedWritesLogger.class);
    private final AtomicBoolean stop = new AtomicBoolean(false);

    @Override
    public void init() {
        Logger.info("-------LOGGER INIT------");
        this.stop.set(false);
    }

    @Override
    public void logFailedWrite(WriteMetadata failedWrite) {
        if (!this.stop.get()) {
            Logger.info("FAILED WRITE: " + failedWrite.toString());
        }
    }

    @Override
    public void shutdown() {
        this.stop.set(true);
        Logger.info("-------LOGGER SHUTDOWN------");
    }
}

