/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.netflix.astyanax.cql.reads.CFColumnQueryGen;
import com.netflix.astyanax.cql.reads.CFRowKeysQueryGen;
import com.netflix.astyanax.cql.reads.CFRowRangeQueryGen;
import com.netflix.astyanax.cql.reads.CqlColumnQueryImpl;
import com.netflix.astyanax.cql.reads.CqlRowQueryImpl;
import com.netflix.astyanax.cql.reads.CqlRowSliceQueryImpl;
import com.netflix.astyanax.cql.reads.FlatTableRowQueryGen;
import com.netflix.astyanax.cql.reads.FlatTableRowSliceQueryGen;
import com.netflix.astyanax.cql.reads.QueryGenCache;
import com.netflix.astyanax.cql.reads.model.CqlColumnSlice;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.serializers.CompositeRangeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class CFRowQueryGen {
    private final AtomicReference<Session> sessionRef = new AtomicReference<Object>(null);
    private final String keyspace;
    private final CqlColumnFamilyDefinitionImpl cfDef;
    private final String partitionKeyCol;
    private final String[] allPrimayKeyCols;
    private final List<ColumnDefinition> clusteringKeyCols;
    private final List<ColumnDefinition> regularCols;
    private boolean isCompositeColumn;
    private boolean isFlatTable;
    private static final String BIND_MARKER = "?";
    private final CFRowKeysQueryGen rowKeysQueryGen;
    private final CFRowRangeQueryGen rowRangeQueryGen;
    private final FlatTableRowQueryGen flatTableRowQueryGen;
    private final FlatTableRowSliceQueryGen flatTableRowSliceQueryGen;
    private final CFColumnQueryGen columnQueryGen;
    private QueryGenCache<CqlRowQueryImpl<?, ?>> SelectEntireRow = new QueryGenCache<CqlRowQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(CqlRowQueryImpl<?, ?> rowQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    Select.Selection select = QueryBuilder.select();
                    for (int i = 0; i < CFRowQueryGen.this.allPrimayKeyCols.length; ++i) {
                        select.column(CFRowQueryGen.this.allPrimayKeyCols[i]);
                    }
                    for (ColumnDefinition colDef : CFRowQueryGen.this.regularCols) {
                        String colName = colDef.getName();
                        select.column(colName).ttl(colName).writeTime(colName);
                    }
                    Select.Where stmt = select.from(CFRowQueryGen.this.keyspace, CFRowQueryGen.this.cfDef.getName()).where(QueryBuilder.eq((String)CFRowQueryGen.this.partitionKeyCol, (Object)CFRowQueryGen.BIND_MARKER));
                    return stmt;
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowQueryImpl<?, ?> rowQuery) {
            return pStatement.bind(new Object[]{rowQuery.getRowKey()});
        }
    };
    private QueryGenCache<CqlRowQueryImpl<?, ?>> SelectColumnSliceWithClusteringKey = new QueryGenCache<CqlRowQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlRowQueryImpl<?, ?> rowQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    if (CFRowQueryGen.this.clusteringKeyCols.size() != 1) {
                        throw new RuntimeException("Cannot perform column slice query with clusteringKeyCols.size: " + CFRowQueryGen.this.clusteringKeyCols.size());
                    }
                    Select.Selection select = QueryBuilder.select();
                    for (int i = 0; i < CFRowQueryGen.this.allPrimayKeyCols.length; ++i) {
                        select.column(CFRowQueryGen.this.allPrimayKeyCols[i]);
                    }
                    for (ColumnDefinition colDef : CFRowQueryGen.this.regularCols) {
                        String colName = colDef.getName();
                        select.column(colName).ttl(colName).writeTime(colName);
                    }
                    int numCols = rowQuery.getColumnSlice().getColumns().size();
                    ArrayList<String> colSelection = new ArrayList<String>();
                    for (int i = 0; i < numCols; ++i) {
                        colSelection.add(CFRowQueryGen.BIND_MARKER);
                    }
                    return select.from(CFRowQueryGen.this.keyspace, CFRowQueryGen.this.cfDef.getName()).where(QueryBuilder.eq((String)CFRowQueryGen.this.partitionKeyCol, (Object)CFRowQueryGen.BIND_MARKER)).and(QueryBuilder.in((String)((ColumnDefinition)CFRowQueryGen.this.clusteringKeyCols.get(0)).getName(), (Object[])colSelection.toArray(new Object[colSelection.size()])));
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowQueryImpl<?, ?> rowQuery) {
            ArrayList<Object> objects = new ArrayList<Object>();
            objects.add(rowQuery.getRowKey());
            for (Object col : rowQuery.getColumnSlice().getColumns()) {
                objects.add(col);
            }
            return pStatement.bind(objects.toArray(new Object[objects.size()]));
        }
    };
    private QueryGenCache<CqlRowQueryImpl<?, ?>> SelectColumnRangeWithClusteringKey = new QueryGenCache<CqlRowQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlRowQueryImpl<?, ?> rowQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    if (CFRowQueryGen.this.clusteringKeyCols.size() != 1) {
                        throw new RuntimeException("Cannot perform col range query with current schema, missing pk cols");
                    }
                    Select.Selection select = QueryBuilder.select();
                    for (int i = 0; i < CFRowQueryGen.this.allPrimayKeyCols.length; ++i) {
                        select.column(CFRowQueryGen.this.allPrimayKeyCols[i]);
                    }
                    for (ColumnDefinition colDef : CFRowQueryGen.this.regularCols) {
                        String colName = colDef.getName();
                        select.column(colName).ttl(colName).writeTime(colName);
                    }
                    Select.Where where = select.from(CFRowQueryGen.this.keyspace, CFRowQueryGen.this.cfDef.getName()).where(QueryBuilder.eq((String)CFRowQueryGen.this.partitionKeyCol, (Object)CFRowQueryGen.BIND_MARKER));
                    String clusterKeyCol = ((ColumnDefinition)CFRowQueryGen.this.clusteringKeyCols.get(0)).getName();
                    CqlColumnSlice columnSlice = rowQuery.getColumnSlice();
                    if (columnSlice.getStartColumn() != null) {
                        where.and(QueryBuilder.gte((String)clusterKeyCol, (Object)CFRowQueryGen.BIND_MARKER));
                    }
                    if (columnSlice.getEndColumn() != null) {
                        where.and(QueryBuilder.lte((String)clusterKeyCol, (Object)CFRowQueryGen.BIND_MARKER));
                    }
                    if (columnSlice.getReversed()) {
                        where.orderBy(new Ordering[]{QueryBuilder.desc((String)clusterKeyCol)});
                    }
                    if (!rowQuery.isPaginating() && columnSlice.getLimit() != -1) {
                        where.limit(columnSlice.getLimit());
                    }
                    return where;
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowQueryImpl<?, ?> rowQuery) {
            if (CFRowQueryGen.this.clusteringKeyCols.size() != 1) {
                throw new RuntimeException("Cannot perform col range query with current schema, missing pk cols");
            }
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(rowQuery.getRowKey());
            CqlColumnSlice<?> columnSlice = rowQuery.getColumnSlice();
            if (columnSlice.getStartColumn() != null) {
                values.add(columnSlice.getStartColumn());
            }
            if (columnSlice.getEndColumn() != null) {
                values.add(columnSlice.getEndColumn());
            }
            return pStatement.bind(values.toArray(new Object[values.size()]));
        }
    };
    private QueryGenCache<CqlRowQueryImpl<?, ?>> SelectWithCompositeColumn = new QueryGenCache<CqlRowQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlRowQueryImpl<?, ?> rowQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    Select.Selection select = QueryBuilder.select();
                    for (int i = 0; i < CFRowQueryGen.this.allPrimayKeyCols.length; ++i) {
                        select.column(CFRowQueryGen.this.allPrimayKeyCols[i]);
                    }
                    for (ColumnDefinition colDef : CFRowQueryGen.this.regularCols) {
                        String colName = colDef.getName();
                        select.column(colName).ttl(colName).writeTime(colName);
                    }
                    Select.Where stmt = select.from(CFRowQueryGen.this.keyspace, CFRowQueryGen.this.cfDef.getName()).where(QueryBuilder.eq((String)CFRowQueryGen.this.partitionKeyCol, (Object)CFRowQueryGen.BIND_MARKER));
                    List records = rowQuery.getCompositeRange().getRecords();
                    int componentIndex = 0;
                    for (CompositeRangeBuilder.RangeQueryRecord record : records) {
                        block10: for (CompositeRangeBuilder.RangeQueryOp op : record.getOps()) {
                            String columnName = ((ColumnDefinition)CFRowQueryGen.this.clusteringKeyCols.get(componentIndex)).getName();
                            switch (op.getOperator()) {
                                case EQUAL: {
                                    stmt.and(QueryBuilder.eq((String)columnName, (Object)CFRowQueryGen.BIND_MARKER));
                                    ++componentIndex;
                                    continue block10;
                                }
                                case LESS_THAN: {
                                    stmt.and(QueryBuilder.lt((String)columnName, (Object)CFRowQueryGen.BIND_MARKER));
                                    continue block10;
                                }
                                case LESS_THAN_EQUALS: {
                                    stmt.and(QueryBuilder.lte((String)columnName, (Object)CFRowQueryGen.BIND_MARKER));
                                    continue block10;
                                }
                                case GREATER_THAN: {
                                    stmt.and(QueryBuilder.gt((String)columnName, (Object)CFRowQueryGen.BIND_MARKER));
                                    continue block10;
                                }
                                case GREATER_THAN_EQUALS: {
                                    stmt.and(QueryBuilder.gte((String)columnName, (Object)CFRowQueryGen.BIND_MARKER));
                                    continue block10;
                                }
                            }
                            throw new RuntimeException("Cannot recognize operator: " + op.getOperator().name());
                        }
                    }
                    return stmt;
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowQueryImpl<?, ?> rowQuery) {
            List records = rowQuery.getCompositeRange().getRecords();
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(rowQuery.getRowKey());
            for (CompositeRangeBuilder.RangeQueryRecord record : records) {
                block8: for (CompositeRangeBuilder.RangeQueryOp op : record.getOps()) {
                    switch (op.getOperator()) {
                        case EQUAL: {
                            values.add(op.getValue());
                            continue block8;
                        }
                        case LESS_THAN: {
                            values.add(op.getValue());
                            continue block8;
                        }
                        case LESS_THAN_EQUALS: {
                            values.add(op.getValue());
                            continue block8;
                        }
                        case GREATER_THAN: {
                            values.add(op.getValue());
                            continue block8;
                        }
                        case GREATER_THAN_EQUALS: {
                            values.add(op.getValue());
                            continue block8;
                        }
                    }
                    throw new RuntimeException("Cannot recognize operator: " + op.getOperator().name());
                }
            }
            return pStatement.bind(values.toArray(new Object[values.size()]));
        }
    };

    public CFRowQueryGen(Session session, String keyspaceName, CqlColumnFamilyDefinitionImpl cfDefinition) {
        this.keyspace = keyspaceName;
        this.cfDef = cfDefinition;
        this.sessionRef.set(session);
        this.partitionKeyCol = this.cfDef.getPartitionKeyColumnDefinition().getName();
        this.allPrimayKeyCols = this.cfDef.getAllPkColNames();
        this.clusteringKeyCols = this.cfDef.getClusteringKeyColumnDefinitionList();
        this.regularCols = this.cfDef.getRegularColumnDefinitionList();
        this.isCompositeColumn = this.clusteringKeyCols.size() > 1;
        this.isFlatTable = this.clusteringKeyCols.size() == 0;
        this.rowKeysQueryGen = new CFRowKeysQueryGen(session, keyspaceName, cfDefinition);
        this.rowRangeQueryGen = new CFRowRangeQueryGen(session, keyspaceName, cfDefinition);
        this.flatTableRowQueryGen = new FlatTableRowQueryGen(session, keyspaceName, cfDefinition);
        this.flatTableRowSliceQueryGen = new FlatTableRowSliceQueryGen(session, keyspaceName, cfDefinition);
        this.columnQueryGen = new CFColumnQueryGen(session, keyspaceName, cfDefinition);
    }

    public Statement getQueryStatement(CqlRowQueryImpl<?, ?> rowQuery, boolean useCaching) {
        if (this.isFlatTable) {
            return this.flatTableRowQueryGen.getQueryStatement(rowQuery, useCaching);
        }
        switch (rowQuery.getQueryType()) {
            case AllColumns: {
                return this.SelectEntireRow.getBoundStatement(rowQuery, useCaching);
            }
            case ColumnSlice: {
                return this.SelectColumnSliceWithClusteringKey.getBoundStatement(rowQuery, useCaching);
            }
            case ColumnRange: {
                if (this.isCompositeColumn) {
                    return this.SelectWithCompositeColumn.getBoundStatement(rowQuery, useCaching);
                }
                return this.SelectColumnRangeWithClusteringKey.getBoundStatement(rowQuery, useCaching);
            }
        }
        throw new RuntimeException("RowQuery use case not supported. Fix this!!");
    }

    public Statement getQueryStatement(CqlRowSliceQueryImpl<?, ?> rowSliceQuery, boolean useCaching) {
        if (this.isFlatTable) {
            return this.flatTableRowSliceQueryGen.getQueryStatement(rowSliceQuery, useCaching);
        }
        switch (rowSliceQuery.getRowQueryType()) {
            case RowKeys: {
                return this.rowKeysQueryGen.getQueryStatement(rowSliceQuery, useCaching);
            }
            case RowRange: {
                return this.rowRangeQueryGen.getQueryStatement(rowSliceQuery, useCaching);
            }
        }
        throw new RuntimeException("RowSliceQuery use case not supported. Fix this!!");
    }

    public Statement getQueryStatement(CqlColumnQueryImpl<?> columnQuery, boolean useCaching) {
        return this.columnQueryGen.getQueryStatement(columnQuery, useCaching);
    }
}

