/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.netflix.astyanax.cql.reads.model.CqlColumnSlice;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.serializers.CompositeRangeBuilder;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class CFRowSliceQueryGen {
    protected final AtomicReference<Session> sessionRef = new AtomicReference<Object>(null);
    protected final String keyspace;
    protected final CqlColumnFamilyDefinitionImpl cfDef;
    protected final String partitionKeyCol;
    protected final String[] allPrimayKeyCols;
    protected final List<ColumnDefinition> clusteringKeyCols;
    protected final List<ColumnDefinition> regularCols;
    protected boolean isCompositeColumn;
    protected static final String BIND_MARKER = "?";

    public CFRowSliceQueryGen(Session session, String keyspaceName, CqlColumnFamilyDefinitionImpl cfDefinition) {
        this.keyspace = keyspaceName;
        this.cfDef = cfDefinition;
        this.sessionRef.set(session);
        this.partitionKeyCol = this.cfDef.getPartitionKeyColumnDefinition().getName();
        this.allPrimayKeyCols = this.cfDef.getAllPkColNames();
        this.clusteringKeyCols = this.cfDef.getClusteringKeyColumnDefinitionList();
        this.regularCols = this.cfDef.getRegularColumnDefinitionList();
        this.isCompositeColumn = this.clusteringKeyCols.size() > 1;
    }

    protected Select selectAllColumnsFromKeyspaceAndCF() {
        Select.Selection select = QueryBuilder.select();
        for (int i = 0; i < this.allPrimayKeyCols.length; ++i) {
            select.column(this.allPrimayKeyCols[i]);
        }
        for (ColumnDefinition colDef : this.regularCols) {
            String colName = colDef.getName();
            select.column(colName).ttl(colName).writeTime(colName);
        }
        return select.from(this.keyspace, this.cfDef.getName());
    }

    protected Select.Where addWhereClauseForColumnRange(Select.Where where, CqlColumnSlice<?> columnSlice) {
        String clusteringKeyCol = this.clusteringKeyCols.get(0).getName();
        if (!columnSlice.isRangeQuery()) {
            return where;
        }
        if (columnSlice.getStartColumn() != null) {
            where.and(QueryBuilder.gte((String)clusteringKeyCol, columnSlice.getStartColumn()));
        }
        if (columnSlice.getEndColumn() != null) {
            where.and(QueryBuilder.lte((String)clusteringKeyCol, columnSlice.getEndColumn()));
        }
        if (columnSlice.getReversed()) {
            where.orderBy(new Ordering[]{QueryBuilder.desc((String)clusteringKeyCol)});
        }
        if (columnSlice.getLimit() != -1) {
            where.limit(columnSlice.getLimit());
        }
        return where;
    }

    protected void bindWhereClauseForColumnRange(List<Object> values, CqlColumnSlice<?> columnSlice) {
        if (!columnSlice.isRangeQuery()) {
            return;
        }
        if (columnSlice.getStartColumn() != null) {
            values.add(columnSlice.getStartColumn());
        }
        if (columnSlice.getEndColumn() != null) {
            values.add(columnSlice.getEndColumn());
        }
        if (columnSlice.getLimit() != -1) {
            values.add(columnSlice.getLimit());
        }
    }

    protected Select.Where addWhereClauseForCompositeColumnRange(Select.Where stmt, CompositeRangeBuilder.CompositeByteBufferRange compositeRange) {
        List records = compositeRange.getRecords();
        int componentIndex = 0;
        for (CompositeRangeBuilder.RangeQueryRecord record : records) {
            block8: for (CompositeRangeBuilder.RangeQueryOp op : record.getOps()) {
                String columnName = this.clusteringKeyCols.get(componentIndex).getName();
                switch (op.getOperator()) {
                    case EQUAL: {
                        stmt.and(QueryBuilder.eq((String)columnName, (Object)BIND_MARKER));
                        ++componentIndex;
                        continue block8;
                    }
                    case LESS_THAN: {
                        stmt.and(QueryBuilder.lt((String)columnName, (Object)BIND_MARKER));
                        continue block8;
                    }
                    case LESS_THAN_EQUALS: {
                        stmt.and(QueryBuilder.lte((String)columnName, (Object)BIND_MARKER));
                        continue block8;
                    }
                    case GREATER_THAN: {
                        stmt.and(QueryBuilder.gt((String)columnName, (Object)BIND_MARKER));
                        continue block8;
                    }
                    case GREATER_THAN_EQUALS: {
                        stmt.and(QueryBuilder.gte((String)columnName, (Object)BIND_MARKER));
                        continue block8;
                    }
                }
                throw new RuntimeException("Cannot recognize operator: " + op.getOperator().name());
            }
        }
        return stmt;
    }

    protected void bindWhereClauseForCompositeColumnRange(List<Object> values, CompositeRangeBuilder.CompositeByteBufferRange compositeRange) {
        List records = compositeRange.getRecords();
        for (CompositeRangeBuilder.RangeQueryRecord record : records) {
            for (CompositeRangeBuilder.RangeQueryOp op : record.getOps()) {
                values.add(op.getValue());
            }
        }
    }

    protected Object[] bindMarkerArray(int n) {
        Object[] arr = new Object[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = BIND_MARKER;
        }
        return arr;
    }
}

