/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlAbstractExecutionImpl;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.query.ColumnCountQuery;
import java.util.List;

public class CqlColumnCountQueryImpl
implements ColumnCountQuery {
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;
    private final CFQueryContext<?, ?> cfContext;
    private final Statement query;

    public CqlColumnCountQueryImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, CFQueryContext<?, ?> cfCtx, Statement query) {
        this.ksContext = ksCtx;
        this.cfContext = cfCtx;
        this.query = query;
    }

    public OperationResult<Integer> execute() throws ConnectionException {
        return new InternalColumnCountExecutionImpl(this.query).execute();
    }

    public ListenableFuture<OperationResult<Integer>> executeAsync() throws ConnectionException {
        return new InternalColumnCountExecutionImpl(this.query).executeAsync();
    }

    private class InternalColumnCountExecutionImpl
    extends CqlAbstractExecutionImpl<Integer> {
        public InternalColumnCountExecutionImpl(Statement query) {
            super(CqlColumnCountQueryImpl.this.ksContext, CqlColumnCountQueryImpl.this.cfContext);
        }

        @Override
        public CassandraOperationType getOperationType() {
            return CassandraOperationType.GET_COLUMN_COUNT;
        }

        @Override
        public Statement getQuery() {
            return CqlColumnCountQueryImpl.this.query;
        }

        @Override
        public Integer parseResultSet(ResultSet resultSet) {
            List rows = resultSet.all();
            if (rows != null) {
                return rows.size();
            }
            return 0;
        }
    }
}

