/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.reads.CqlAllRowsQueryImpl;
import com.netflix.astyanax.cql.reads.CqlRowQueryImpl;
import com.netflix.astyanax.cql.reads.CqlRowSliceQueryImpl;
import com.netflix.astyanax.cql.reads.DirectCqlQueryImpl;
import com.netflix.astyanax.cql.reads.model.CqlRowSlice;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.query.AllRowsQuery;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.query.CqlQuery;
import com.netflix.astyanax.query.IndexQuery;
import com.netflix.astyanax.query.RowQuery;
import com.netflix.astyanax.query.RowSliceQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CqlColumnFamilyQueryImpl<K, C>
implements ColumnFamilyQuery<K, C> {
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;
    private final CFQueryContext<K, C> cfContext;
    private boolean useCaching = false;

    public CqlColumnFamilyQueryImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, ColumnFamily<K, C> cf) {
        this.ksContext = ksCtx;
        this.cfContext = new CFQueryContext<K, C>(cf);
        this.cfContext.setConsistencyLevel(ConsistencyLevel.CL_ONE);
    }

    public ColumnFamilyQuery<K, C> setConsistencyLevel(ConsistencyLevel clLevel) {
        this.cfContext.setConsistencyLevel(clLevel);
        return this;
    }

    public ColumnFamilyQuery<K, C> withRetryPolicy(RetryPolicy retry) {
        this.cfContext.setRetryPolicy(retry.duplicate());
        return this;
    }

    public ColumnFamilyQuery<K, C> pinToHost(Host host) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public RowQuery<K, C> getKey(K rowKey) {
        return new CqlRowQueryImpl<K, C>(this.ksContext, this.cfContext, rowKey, this.useCaching);
    }

    public RowQuery<K, C> getRow(K rowKey) {
        return new CqlRowQueryImpl<K, C>(this.ksContext, this.cfContext, rowKey, this.useCaching);
    }

    public RowSliceQuery<K, C> getKeyRange(K startKey, K endKey, String startToken, String endToken, int count) {
        return this.getRowRange(startKey, endKey, startToken, endToken, count);
    }

    public RowSliceQuery<K, C> getRowRange(K startKey, K endKey, String startToken, String endToken, int count) {
        CqlRowSlice<K> rowSlice = new CqlRowSlice<K>(startKey, endKey, startToken, endToken, count);
        return new CqlRowSliceQueryImpl<K, C>(this.ksContext, this.cfContext, rowSlice, this.useCaching);
    }

    public RowSliceQuery<K, C> getKeySlice(K ... keys) {
        return this.getRowSlice(keys);
    }

    public RowSliceQuery<K, C> getRowSlice(K ... keys) {
        List<K> keyList = Arrays.asList(keys);
        return this.getRowSlice((Collection<K>)keyList);
    }

    public RowSliceQuery<K, C> getKeySlice(Collection<K> keys) {
        return this.getRowSlice(keys);
    }

    public RowSliceQuery<K, C> getRowSlice(Collection<K> keys) {
        CqlRowSlice<K> rowSlice = new CqlRowSlice<K>(keys);
        return new CqlRowSliceQueryImpl<K, C>(this.ksContext, this.cfContext, rowSlice, this.useCaching);
    }

    public RowSliceQuery<K, C> getKeySlice(Iterable<K> keys) {
        return this.getRowSlice(keys);
    }

    public RowSliceQuery<K, C> getRowSlice(Iterable<K> keys) {
        ArrayList<K> keyList = new ArrayList<K>();
        for (K key : keys) {
            keyList.add(key);
        }
        return this.getRowSlice((Collection<K>)keyList);
    }

    public AllRowsQuery<K, C> getAllRows() {
        return new CqlAllRowsQueryImpl<K, C>(this.ksContext.getKeyspaceContext(), this.cfContext.getColumnFamily());
    }

    public CqlQuery<K, C> withCql(String cql) {
        return new DirectCqlQueryImpl<K, C>(this.ksContext, this.cfContext, cql);
    }

    public IndexQuery<K, C> searchWithIndex() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnFamilyQuery<K, C> withCaching(boolean condition) {
        this.useCaching = condition;
        return this;
    }
}

