/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlAbstractExecutionImpl;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.reads.model.DirectCqlResult;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.model.CqlResult;
import com.netflix.astyanax.query.CqlQuery;
import com.netflix.astyanax.query.PreparedCqlQuery;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.NotImplementedException;

public class DirectCqlQueryImpl<K, C>
implements CqlQuery<K, C> {
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;
    private final CFQueryContext<K, C> cfContext;
    private final String basicCqlQuery;

    public DirectCqlQueryImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, CFQueryContext<K, C> cfCtx, String basicCqlQuery) {
        this.ksContext = ksCtx;
        this.cfContext = cfCtx;
        this.basicCqlQuery = basicCqlQuery;
    }

    public OperationResult<CqlResult<K, C>> execute() throws ConnectionException {
        return new InternalExecutionImpl((Statement)new SimpleStatement(this.basicCqlQuery)).execute();
    }

    public ListenableFuture<OperationResult<CqlResult<K, C>>> executeAsync() throws ConnectionException {
        return new InternalExecutionImpl((Statement)new SimpleStatement(this.basicCqlQuery)).executeAsync();
    }

    public CqlQuery<K, C> useCompression() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public PreparedCqlQuery<K, C> asPreparedStatement() {
        return new InternalPreparedStatement();
    }

    private class InternalExecutionImpl
    extends CqlAbstractExecutionImpl<CqlResult<K, C>> {
        private final Statement query;

        public InternalExecutionImpl(Statement query) {
            super(DirectCqlQueryImpl.this.ksContext, DirectCqlQueryImpl.this.cfContext);
            this.query = query;
        }

        @Override
        public CassandraOperationType getOperationType() {
            return CassandraOperationType.CQL;
        }

        @Override
        public Statement getQuery() {
            return this.query;
        }

        @Override
        public CqlResult<K, C> parseResultSet(ResultSet resultSet) {
            boolean isCountQuery = DirectCqlQueryImpl.this.basicCqlQuery.contains(" count(");
            if (isCountQuery) {
                return new DirectCqlResult(new Long(resultSet.one().getLong(0)));
            }
            return new DirectCqlResult(resultSet.all(), this.cf);
        }
    }

    protected class InternalBoundStatement
    implements PreparedCqlQuery<K, C> {
        final List<Object> bindList = new ArrayList<Object>();
        final BoundStatement boundStatement;

        protected InternalBoundStatement(PreparedStatement pStmt) {
            this.boundStatement = new BoundStatement(pStmt);
        }

        public OperationResult<CqlResult<K, C>> execute() throws ConnectionException {
            this.boundStatement.bind(this.bindList.toArray());
            return new InternalExecutionImpl((Statement)this.boundStatement).execute();
        }

        public ListenableFuture<OperationResult<CqlResult<K, C>>> executeAsync() throws ConnectionException {
            this.boundStatement.bind(this.bindList.toArray());
            return new InternalExecutionImpl((Statement)this.boundStatement).executeAsync();
        }

        public <V> PreparedCqlQuery<K, C> withByteBufferValue(V value, Serializer<V> serializer) {
            this.bindList.add(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withValue(ByteBuffer value) {
            this.bindList.add(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withValues(List<ByteBuffer> value) {
            this.bindList.addAll(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withStringValue(String value) {
            this.bindList.add(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withIntegerValue(Integer value) {
            this.bindList.add(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withBooleanValue(Boolean value) {
            this.bindList.add(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withDoubleValue(Double value) {
            this.bindList.add(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withLongValue(Long value) {
            this.bindList.add(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withFloatValue(Float value) {
            this.bindList.add(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withShortValue(Short value) {
            this.bindList.add(value);
            return this;
        }

        public PreparedCqlQuery<K, C> withUUIDValue(UUID value) {
            this.bindList.add(value);
            return this;
        }
    }

    protected class InternalPreparedStatement
    implements PreparedCqlQuery<K, C> {
        private final PreparedStatement pStatement;

        protected InternalPreparedStatement() {
            this.pStatement = DirectCqlQueryImpl.this.ksContext.getSession().prepare(DirectCqlQueryImpl.this.basicCqlQuery);
        }

        public <V> PreparedCqlQuery<K, C> withByteBufferValue(V value, Serializer<V> serializer) {
            return new InternalBoundStatement(this.pStatement).withByteBufferValue(value, serializer);
        }

        public PreparedCqlQuery<K, C> withValue(ByteBuffer value) {
            return new InternalBoundStatement(this.pStatement).withValue(value);
        }

        public PreparedCqlQuery<K, C> withValues(List<ByteBuffer> values) {
            return new InternalBoundStatement(this.pStatement).withValues(values);
        }

        public PreparedCqlQuery<K, C> withStringValue(String value) {
            return new InternalBoundStatement(this.pStatement).withStringValue(value);
        }

        public PreparedCqlQuery<K, C> withIntegerValue(Integer value) {
            return new InternalBoundStatement(this.pStatement).withIntegerValue(value);
        }

        public PreparedCqlQuery<K, C> withBooleanValue(Boolean value) {
            return new InternalBoundStatement(this.pStatement).withBooleanValue(value);
        }

        public PreparedCqlQuery<K, C> withDoubleValue(Double value) {
            return new InternalBoundStatement(this.pStatement).withDoubleValue(value);
        }

        public PreparedCqlQuery<K, C> withLongValue(Long value) {
            return new InternalBoundStatement(this.pStatement).withLongValue(value);
        }

        public PreparedCqlQuery<K, C> withFloatValue(Float value) {
            return new InternalBoundStatement(this.pStatement).withFloatValue(value);
        }

        public PreparedCqlQuery<K, C> withShortValue(Short value) {
            return new InternalBoundStatement(this.pStatement).withShortValue(value);
        }

        public PreparedCqlQuery<K, C> withUUIDValue(UUID value) {
            return new InternalBoundStatement(this.pStatement).withUUIDValue(value);
        }

        public OperationResult<CqlResult<K, C>> execute() throws ConnectionException {
            throw new NotImplementedException();
        }

        public ListenableFuture<OperationResult<CqlResult<K, C>>> executeAsync() throws ConnectionException {
            throw new NotImplementedException();
        }
    }
}

