/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.netflix.astyanax.cql.reads.CqlRowQueryImpl;
import com.netflix.astyanax.cql.reads.QueryGenCache;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.ddl.ColumnDefinition;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class FlatTableRowQueryGen {
    private AtomicReference<Session> sessionRef = new AtomicReference<Object>(null);
    private final String keyspace;
    private final CqlColumnFamilyDefinitionImpl cfDef;
    private final String partitionKeyCol;
    private final String[] allPrimayKeyCols;
    private final List<ColumnDefinition> regularCols;
    private static final String BIND_MARKER = "?";
    private QueryGenCache<CqlRowQueryImpl<?, ?>> SelectEntireRow = new QueryGenCache<CqlRowQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(CqlRowQueryImpl<?, ?> rowQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    Select.Selection select = QueryBuilder.select();
                    for (int i = 0; i < FlatTableRowQueryGen.this.allPrimayKeyCols.length; ++i) {
                        select.column(FlatTableRowQueryGen.this.allPrimayKeyCols[i]);
                    }
                    for (ColumnDefinition colDef : FlatTableRowQueryGen.this.regularCols) {
                        String colName = colDef.getName();
                        select.column(colName).ttl(colName).writeTime(colName);
                    }
                    Select.Where stmt = select.from(FlatTableRowQueryGen.this.keyspace, FlatTableRowQueryGen.this.cfDef.getName()).where(QueryBuilder.eq((String)FlatTableRowQueryGen.this.partitionKeyCol, (Object)FlatTableRowQueryGen.BIND_MARKER));
                    return stmt;
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowQueryImpl<?, ?> rowQuery) {
            return pStatement.bind(new Object[]{rowQuery.getRowKey()});
        }
    };
    private QueryGenCache<CqlRowQueryImpl<?, ?>> SelectColumnSlice = new QueryGenCache<CqlRowQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlRowQueryImpl<?, ?> rowQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    Select.Selection select = QueryBuilder.select();
                    select.column(FlatTableRowQueryGen.this.partitionKeyCol);
                    for (Object col : rowQuery.getColumnSlice().getColumns()) {
                        String columnName = (String)col;
                        select.column(columnName).ttl(columnName).writeTime(columnName);
                    }
                    return select.from(FlatTableRowQueryGen.this.keyspace, FlatTableRowQueryGen.this.cfDef.getName()).where(QueryBuilder.eq((String)FlatTableRowQueryGen.this.partitionKeyCol, (Object)FlatTableRowQueryGen.BIND_MARKER));
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowQueryImpl<?, ?> rowQuery) {
            return pStatement.bind(new Object[]{rowQuery.getRowKey()});
        }
    };

    public FlatTableRowQueryGen(Session session, String keyspaceName, CqlColumnFamilyDefinitionImpl cfDefinition) {
        this.keyspace = keyspaceName;
        this.cfDef = cfDefinition;
        this.sessionRef.set(session);
        this.partitionKeyCol = this.cfDef.getPartitionKeyColumnDefinition().getName();
        this.allPrimayKeyCols = this.cfDef.getAllPkColNames();
        this.regularCols = this.cfDef.getRegularColumnDefinitionList();
    }

    public Statement getQueryStatement(CqlRowQueryImpl<?, ?> rowQuery, boolean useCaching) {
        switch (rowQuery.getQueryType()) {
            case AllColumns: {
                return this.SelectEntireRow.getBoundStatement(rowQuery, useCaching);
            }
            case ColumnSlice: {
                return this.SelectColumnSlice.getBoundStatement(rowQuery, useCaching);
            }
            case ColumnRange: {
                throw new RuntimeException("Cannot perform col range query with current schema, missing pk cols");
            }
        }
        throw new RuntimeException("Flat table RowQuery use case not supported. Fix this!!");
    }
}

