/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads.model;

import com.datastax.driver.core.ResultSet;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.reads.model.CqlRowImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.util.CqlTypeMapping;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class CqlRowListIterator<K, C>
implements Rows<K, C> {
    private final ResultSet resultSet;
    private final ColumnFamily<K, C> cf;
    private final Serializer<K> keySerializer;
    private final boolean isClusteringKey;
    private final AtomicReference<State> stateRef = new AtomicReference<State>(State.UnSet);
    private final AtomicInteger iterRowCount = new AtomicInteger(0);
    private final AtomicReference<Iterator<Row<K, C>>> iterRef = new AtomicReference<Object>(null);
    private final List<Row<K, C>> rows = new ArrayList<Row<K, C>>();
    private final Map<K, Row<K, C>> lookup = new HashMap<K, Row<K, C>>();

    public CqlRowListIterator(ResultSet rs, ColumnFamily<K, C> cf) {
        this.resultSet = rs;
        this.cf = cf;
        this.keySerializer = cf.getKeySerializer();
        CqlColumnFamilyDefinitionImpl cfDef = (CqlColumnFamilyDefinitionImpl)cf.getColumnFamilyDefinition();
        this.isClusteringKey = cfDef.getClusteringKeyColumnDefinitionList().size() > 0;
    }

    public Iterator<Row<K, C>> iterator() {
        if (this.iterRef.get() != null) {
            return this.iterRef.get();
        }
        if (this.stateRef.get() == State.UnSet) {
            this.stateRef.set(State.Iterator);
        }
        Iterator rowIter = new Iterator<Row<K, C>>(){
            private final Iterator<com.datastax.driver.core.Row> rsIter;
            private List<com.datastax.driver.core.Row> currentList;
            private K currentRowKey;
            {
                this.rsIter = CqlRowListIterator.this.resultSet.iterator();
                this.currentList = new ArrayList<com.datastax.driver.core.Row>();
                this.currentRowKey = null;
            }

            @Override
            public boolean hasNext() {
                if (!CqlRowListIterator.this.isClusteringKey) {
                    return this.rsIter.hasNext();
                }
                return this.rsIter.hasNext() || !this.currentList.isEmpty();
            }

            @Override
            public Row<K, C> next() {
                if (CqlRowListIterator.this.isClusteringKey) {
                    while (this.rsIter.hasNext()) {
                        com.datastax.driver.core.Row rsRow = this.rsIter.next();
                        Object rowKey = CqlTypeMapping.getDynamicColumn(rsRow, CqlRowListIterator.this.keySerializer, 0, CqlRowListIterator.this.cf);
                        if (this.currentRowKey == null || rowKey.equals(this.currentRowKey)) {
                            this.currentList.add(rsRow);
                            this.currentRowKey = rowKey;
                            continue;
                        }
                        ArrayList<com.datastax.driver.core.Row> newList = new ArrayList<com.datastax.driver.core.Row>();
                        newList.addAll(this.currentList);
                        this.currentList = new ArrayList<com.datastax.driver.core.Row>();
                        this.currentList.add(rsRow);
                        this.currentRowKey = rowKey;
                        CqlRowListIterator.this.iterRowCount.incrementAndGet();
                        return new CqlRowImpl(newList, CqlRowListIterator.this.cf);
                    }
                    ArrayList<com.datastax.driver.core.Row> newList = new ArrayList<com.datastax.driver.core.Row>();
                    newList.addAll(this.currentList);
                    this.currentList = new ArrayList<com.datastax.driver.core.Row>();
                    CqlRowListIterator.this.iterRowCount.incrementAndGet();
                    return new CqlRowImpl(newList, CqlRowListIterator.this.cf);
                }
                if (this.rsIter.hasNext()) {
                    com.datastax.driver.core.Row rsRow = this.rsIter.next();
                    return new CqlRowImpl(rsRow, CqlRowListIterator.this.cf);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        this.iterRef.set(rowIter);
        return this.iterRef.get();
    }

    public Collection<K> getKeys() {
        this.consumeAllRows();
        return this.lookup.keySet();
    }

    public Row<K, C> getRow(K key) {
        this.consumeAllRows();
        return this.lookup.get(key);
    }

    public Row<K, C> getRowByIndex(int i) {
        this.consumeAllRows();
        return this.rows.get(i);
    }

    public int size() {
        if (this.stateRef.get() == State.Iterator) {
            return this.iterRowCount.get();
        }
        this.consumeAllRows();
        return this.rows.size();
    }

    public boolean isEmpty() {
        if (this.stateRef.get() == State.UnSet) {
            this.iterator();
        }
        if (this.stateRef.get() == State.Iterator) {
            return !this.iterRef.get().hasNext();
        }
        this.consumeAllRows();
        return this.rows.size() == 0;
    }

    private void consumeAllRows() {
        if (this.stateRef.get() == State.PrefetchDone) {
            return;
        }
        if (this.stateRef.get() == State.Iterator) {
            throw new RuntimeException("Cannot pre-fetch rows while iterating over rows");
        }
        this.stateRef.set(State.PreFetch);
        Iterator<Row<K, C>> rowIter = this.iterator();
        while (rowIter.hasNext()) {
            Row<K, C> row = rowIter.next();
            this.rows.add(row);
            this.lookup.put(row.getKey(), row);
        }
        this.iterRef.set(this.rows.iterator());
        this.stateRef.set(State.PrefetchDone);
    }

    private static enum State {
        UnSet,
        PreFetch,
        PrefetchDone,
        Iterator;

    }
}

