/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.writes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Clock;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.WriteAheadLog;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;

public abstract class AbstractMutationBatchImpl
implements MutationBatch {
    protected Long timestamp = null;
    protected ConsistencyLevel consistencyLevel;
    protected Clock clock;
    protected Host pinnedHost;
    protected RetryPolicy retry;
    protected WriteAheadLog wal;
    protected boolean useAtomicBatch = false;
    protected String keyspace;
    protected Map<ByteBuffer, Map<String, ColumnListMutation<?>>> mutationMap = Maps.newLinkedHashMap();
    protected Map<KeyAndColumnFamily, ColumnListMutation<?>> rowLookup = Maps.newHashMap();

    public AbstractMutationBatchImpl(Clock clock, ConsistencyLevel consistencyLevel, RetryPolicy retry) {
        this.clock = clock;
        this.timestamp = null;
        this.consistencyLevel = consistencyLevel;
        this.retry = retry;
    }

    public <K, C> ColumnListMutation<C> withRow(ColumnFamily<K, C> columnFamily, K rowKey) {
        Preconditions.checkNotNull(columnFamily, (Object)"columnFamily cannot be null");
        Preconditions.checkNotNull(rowKey, (Object)"Row key cannot be null");
        ByteBuffer bbKey = columnFamily.getKeySerializer().toByteBuffer(rowKey);
        if (!bbKey.hasRemaining()) {
            throw new RuntimeException("Row key cannot be empty");
        }
        KeyAndColumnFamily kacf = new KeyAndColumnFamily(columnFamily.getName(), bbKey);
        Object clm = this.rowLookup.get(kacf);
        if (clm == null) {
            ColumnListMutation<C> innerMutationList;
            HashMap innerMutationMap = this.mutationMap.get(bbKey);
            if (innerMutationMap == null) {
                innerMutationMap = Maps.newHashMap();
                this.mutationMap.put(bbKey, innerMutationMap);
            }
            if ((innerMutationList = (ColumnListMutation<C>)innerMutationMap.get(columnFamily.getName())) == null) {
                innerMutationList = this.createColumnListMutation(this.keyspace, columnFamily, rowKey);
                innerMutationMap.put(columnFamily.getName(), innerMutationList);
            }
            this.rowLookup.put(kacf, innerMutationList);
            clm = innerMutationList;
        }
        return clm;
    }

    public abstract <K, C> ColumnListMutation<C> createColumnListMutation(String var1, ColumnFamily<K, C> var2, K var3);

    public void discardMutations() {
        this.timestamp = null;
        this.mutationMap.clear();
        this.rowLookup.clear();
        this.withCaching(false);
    }

    public <K> void deleteRow(Iterable<? extends ColumnFamily<K, ?>> columnFamilies, K rowKey) {
        for (ColumnFamily<K, ?> cf : columnFamilies) {
            this.withRow(cf, rowKey).delete();
        }
    }

    public boolean isEmpty() {
        return this.mutationMap.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MutationBatch[");
        boolean first = true;
        for (Map.Entry<ByteBuffer, Map<String, ColumnListMutation<?>>> row : this.mutationMap.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(Hex.encodeHex((byte[])row.getKey().array()));
            sb.append(row.getValue().entrySet().toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public ByteBuffer serialize() throws Exception {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void deserialize(ByteBuffer data) throws Exception {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Map<ByteBuffer, Set<String>> getRowKeys() {
        return Maps.transformEntries(this.mutationMap, (Maps.EntryTransformer)new Maps.EntryTransformer<ByteBuffer, Map<String, ColumnListMutation<?>>, Set<String>>(){

            public Set<String> transformEntry(ByteBuffer key, Map<String, ColumnListMutation<?>> value) {
                return value.keySet();
            }
        });
    }

    public Map<ByteBuffer, Map<String, ColumnListMutation<?>>> getMutationMap() {
        return this.mutationMap;
    }

    public void mergeShallow(MutationBatch other) {
        if (!(other instanceof AbstractMutationBatchImpl)) {
            throw new UnsupportedOperationException();
        }
        for (Map.Entry<ByteBuffer, Map<String, ColumnListMutation<?>>> otherRow : ((AbstractMutationBatchImpl)other).mutationMap.entrySet()) {
            Map<String, ColumnListMutation<?>> thisRow = this.mutationMap.get(otherRow.getKey());
            if (thisRow == null) {
                this.mutationMap.put(otherRow.getKey(), otherRow.getValue());
                continue;
            }
            for (Map.Entry<String, ColumnListMutation<?>> otherCf : otherRow.getValue().entrySet()) {
                ColumnListMutation<?> thisCf = thisRow.get(otherCf.getKey());
                if (thisCf == null) {
                    thisRow.put(otherCf.getKey(), otherCf.getValue());
                    continue;
                }
                this.mergeColumnListMutation(otherCf.getValue(), thisCf);
            }
        }
    }

    public abstract void mergeColumnListMutation(ColumnListMutation<?> var1, ColumnListMutation<?> var2);

    public int getRowCount() {
        return this.mutationMap.size();
    }

    public MutationBatch setTimeout(long timeout) {
        return this;
    }

    public MutationBatch setTimestamp(long timestamp) {
        return this.withTimestamp(timestamp);
    }

    public MutationBatch withTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public MutationBatch lockCurrentTimestamp() {
        this.timestamp = this.clock.getCurrentTime();
        return this;
    }

    public MutationBatch setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public MutationBatch withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public MutationBatch pinToHost(Host host) {
        this.pinnedHost = host;
        return this;
    }

    public MutationBatch withRetryPolicy(RetryPolicy retry) {
        this.retry = retry.duplicate();
        return this;
    }

    public MutationBatch usingWriteAheadLog(WriteAheadLog manager) {
        throw new UnsupportedOperationException("Operation not supported. ");
    }

    public MutationBatch withAtomicBatch(boolean condition) {
        this.useAtomicBatch = condition;
        return this;
    }

    public boolean useAtomicBatch() {
        return this.useAtomicBatch;
    }

    public Host getPinnedHost() {
        return this.pinnedHost;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retry;
    }

    public WriteAheadLog getWriteAheadLog() {
        return this.wal;
    }

    private static class KeyAndColumnFamily {
        private final String columnFamily;
        private final ByteBuffer key;

        public KeyAndColumnFamily(String columnFamily, ByteBuffer key) {
            this.columnFamily = columnFamily;
            this.key = key;
        }

        public int compareTo(Object obj) {
            if (obj instanceof KeyAndColumnFamily) {
                KeyAndColumnFamily other = (KeyAndColumnFamily)obj;
                int result = this.columnFamily.compareTo(other.columnFamily);
                if (result == 0) {
                    result = this.key.compareTo(other.key);
                }
                return result;
            }
            return -1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.columnFamily == null ? 0 : this.columnFamily.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyAndColumnFamily other = (KeyAndColumnFamily)obj;
            if (this.columnFamily == null ? other.columnFamily != null : !this.columnFamily.equals(other.columnFamily)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

