/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.mapred.tether.InputProtocol;
import org.apache.avro.mapred.tether.OutputProtocol;
import org.apache.avro.mapred.tether.TetherData;
import org.apache.avro.mapred.tether.TetherOutputService;
import org.apache.avro.specific.SpecificRequestor;
import org.apache.avro.specific.SpecificResponder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;

class TetheredProcess {
    private JobConf job;
    TetherOutputService outputService;
    Server outputServer;
    Process subprocess;
    Transceiver clientTransceiver;
    InputProtocol inputClient;

    public TetheredProcess(JobConf job, OutputCollector<TetherData, NullWritable> collector, Reporter reporter) throws Exception {
        try {
            this.outputService = new TetherOutputService(collector, reporter);
            this.outputServer = new SocketServer(new SpecificResponder(OutputProtocol.class, (Object)this.outputService), new InetSocketAddress(0));
            this.outputServer.start();
            this.subprocess = this.startSubprocess(job);
            this.clientTransceiver = new SocketTransceiver(new InetSocketAddress(this.outputService.inputPort()));
            this.inputClient = (InputProtocol)SpecificRequestor.getClient(InputProtocol.class, this.clientTransceiver);
        }
        catch (Exception t) {
            this.close();
            throw t;
        }
    }

    public void close() {
        if (this.clientTransceiver != null) {
            try {
                this.clientTransceiver.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.subprocess != null) {
            this.subprocess.destroy();
        }
        if (this.outputServer != null) {
            this.outputServer.close();
        }
    }

    private Process startSubprocess(JobConf job) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)job);
        if (localFiles == null) {
            URI[] files = DistributedCache.getCacheFiles((Configuration)job);
            localFiles = new Path[]{new Path(files[0].toString())};
        }
        String executable = localFiles[0].toString();
        FileUtil.chmod((String)executable, (String)"a+x");
        command.add(executable);
        if (System.getProperty("hadoop.log.dir") == null && System.getenv("HADOOP_LOG_DIR") != null) {
            System.setProperty("hadoop.log.dir", System.getenv("HADOOP_LOG_DIR"));
        }
        TaskAttemptID taskid = TaskAttemptID.forName((String)job.get("mapred.task.id"));
        File stdout = TaskLog.getTaskLogFile((TaskAttemptID)taskid, (TaskLog.LogName)TaskLog.LogName.STDOUT);
        File stderr = TaskLog.getTaskLogFile((TaskAttemptID)taskid, (TaskLog.LogName)TaskLog.LogName.STDERR);
        long logLength = TaskLog.getTaskLogLength((JobConf)job);
        command = TaskLog.captureOutAndError(command, (File)stdout, (File)stderr, (long)logLength);
        stdout.getParentFile().mkdirs();
        stderr.getParentFile().mkdirs();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("AVRO_TETHER_OUTPUT_PORT", Integer.toString(this.outputServer.getPort()));
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.environment().putAll(env);
        return builder.start();
    }
}

