/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.exceptions.BadRequestException;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionAbortedException;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.OperationTimeoutException;
import com.netflix.astyanax.connectionpool.exceptions.ThriftStateException;
import com.netflix.astyanax.connectionpool.exceptions.TimeoutException;
import com.netflix.astyanax.connectionpool.exceptions.TokenRangeOfflineException;
import com.netflix.astyanax.connectionpool.exceptions.TransportException;
import com.netflix.astyanax.connectionpool.exceptions.UnknownException;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnPath;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.model.ColumnType;
import com.netflix.astyanax.model.ConsistencyLevel;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftConverter.class);

    public static <K> ColumnParent getColumnParent(ColumnFamily<?, ?> columnFamily, ColumnPath<?> path) throws BadRequestException {
        ColumnParent cp = new ColumnParent();
        cp.setColumn_family(columnFamily.getName());
        if (path != null) {
            Iterator columns = path.iterator();
            if (columnFamily.getType() == ColumnType.SUPER && columns.hasNext()) {
                cp.setSuper_column((ByteBuffer)columns.next());
            }
        }
        return cp;
    }

    public static <K> org.apache.cassandra.thrift.ColumnPath getColumnPath(ColumnFamily<?, ?> columnFamily, ColumnPath<?> path) throws BadRequestException {
        org.apache.cassandra.thrift.ColumnPath cp = new org.apache.cassandra.thrift.ColumnPath();
        cp.setColumn_family(columnFamily.getName());
        if (path != null) {
            Iterator columns = path.iterator();
            if (columnFamily.getType() == ColumnType.SUPER && columns.hasNext()) {
                cp.setSuper_column((ByteBuffer)columns.next());
            }
            if (columns.hasNext()) {
                cp.setColumn((ByteBuffer)columns.next());
            }
            if (columns.hasNext()) {
                throw new BadRequestException("Path depth of " + path.length() + " not supported for column family '" + columnFamily.getName() + "'");
            }
        }
        return cp;
    }

    public static <C> SlicePredicate getPredicate(ColumnSlice<C> columns, Serializer<C> colSer) {
        if (columns == null) {
            SlicePredicate predicate = new SlicePredicate();
            predicate.setSlice_range(new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, Integer.MAX_VALUE));
            return predicate;
        }
        if (columns.getColumns() != null) {
            SlicePredicate predicate = new SlicePredicate();
            predicate.setColumn_namesIsSet(true);
            predicate.column_names = colSer.toBytesList(columns.getColumns());
            return predicate;
        }
        SlicePredicate predicate = new SlicePredicate();
        predicate.setSlice_range(new SliceRange(columns.getStartColumn() == null ? ByteBuffer.wrap(new byte[0]) : ByteBuffer.wrap(colSer.toBytes(columns.getStartColumn())), columns.getEndColumn() == null ? ByteBuffer.wrap(new byte[0]) : ByteBuffer.wrap(colSer.toBytes(columns.getEndColumn())), columns.getReversed(), columns.getLimit()));
        return predicate;
    }

    public static ConnectionException ToConnectionPoolException(Throwable e) {
        if (e instanceof ConnectionException) {
            return (ConnectionException)e;
        }
        LOGGER.debug(e.getMessage());
        if (e instanceof InvalidRequestException) {
            return new BadRequestException(e);
        }
        if (e instanceof TProtocolException) {
            return new BadRequestException(e);
        }
        if (e instanceof UnavailableException) {
            return new TokenRangeOfflineException(e);
        }
        if (e instanceof SocketTimeoutException) {
            return new TimeoutException(e);
        }
        if (e instanceof TimedOutException) {
            return new OperationTimeoutException(e);
        }
        if (e instanceof NotFoundException) {
            return new com.netflix.astyanax.connectionpool.exceptions.NotFoundException(e);
        }
        if (e instanceof TApplicationException) {
            return new ThriftStateException(e);
        }
        if (e instanceof AuthenticationException || e instanceof AuthorizationException) {
            return new com.netflix.astyanax.connectionpool.exceptions.AuthenticationException(e);
        }
        if (e instanceof SchemaDisagreementException) {
            return new com.netflix.astyanax.connectionpool.exceptions.SchemaDisagreementException(e);
        }
        if (e instanceof TTransportException) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof SocketTimeoutException) {
                    return new TimeoutException(e);
                }
                if (e.getCause().getMessage() != null && (e.getCause().getMessage().toLowerCase().contains("connection abort") || e.getCause().getMessage().toLowerCase().contains("connection reset"))) {
                    return new ConnectionAbortedException(e);
                }
            }
            return new TransportException(e);
        }
        return new UnknownException(e);
    }

    public static org.apache.cassandra.thrift.ConsistencyLevel ToThriftConsistencyLevel(ConsistencyLevel cl) {
        switch (cl) {
            case CL_ONE: {
                return org.apache.cassandra.thrift.ConsistencyLevel.ONE;
            }
            case CL_QUORUM: {
                return org.apache.cassandra.thrift.ConsistencyLevel.QUORUM;
            }
            case CL_EACH_QUORUM: {
                return org.apache.cassandra.thrift.ConsistencyLevel.EACH_QUORUM;
            }
            case CL_LOCAL_QUORUM: {
                return org.apache.cassandra.thrift.ConsistencyLevel.LOCAL_QUORUM;
            }
            case CL_TWO: {
                return org.apache.cassandra.thrift.ConsistencyLevel.TWO;
            }
            case CL_THREE: {
                return org.apache.cassandra.thrift.ConsistencyLevel.THREE;
            }
            case CL_ALL: {
                return org.apache.cassandra.thrift.ConsistencyLevel.ALL;
            }
            case CL_ANY: {
                return org.apache.cassandra.thrift.ConsistencyLevel.ANY;
            }
            case CL_LOCAL_ONE: {
                return org.apache.cassandra.thrift.ConsistencyLevel.LOCAL_ONE;
            }
        }
        return org.apache.cassandra.thrift.ConsistencyLevel.QUORUM;
    }
}

