/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.obs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.utils.obs.BitUtil;
import org.apache.cassandra.utils.obs.IBitSet;

public class OpenBitSet
implements IBitSet {
    private final long[][] bits;
    private int wlen;
    private final int pageCount;
    private static final int PAGE_SIZE = 4096;

    public OpenBitSet(long numBits) {
        this.wlen = (int)OpenBitSet.bits2words(numBits);
        int lastPageSize = this.wlen % 4096;
        int fullPageCount = this.wlen / 4096;
        this.pageCount = fullPageCount + (lastPageSize == 0 ? 0 : 1);
        this.bits = new long[this.pageCount][];
        for (int i = 0; i < fullPageCount; ++i) {
            this.bits[i] = new long[4096];
        }
        if (lastPageSize != 0) {
            this.bits[this.bits.length - 1] = new long[lastPageSize];
        }
    }

    public OpenBitSet() {
        this(64L);
    }

    public int getPageSize() {
        return 4096;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public long[] getPage(int pageIdx) {
        return this.bits[pageIdx];
    }

    @Override
    public long capacity() {
        return (long)this.wlen << 6;
    }

    public long size() {
        return this.capacity();
    }

    public long length() {
        return this.capacity();
    }

    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public int getNumWords() {
        return this.wlen;
    }

    public boolean get(int index) {
        int i = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i / 4096][i % 4096] & bitmask) != 0L;
    }

    @Override
    public boolean get(long index) {
        int i = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i / 4096][i % 4096] & bitmask) != 0L;
    }

    @Override
    public void set(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] | bitmask;
    }

    public void set(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] | bitmask;
    }

    public void clear(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void clear(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int startIndex, int endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            long[] lArray = this.bits[startWord / 4096];
            int n = startWord % 4096;
            lArray[n] = lArray[n] & (startmask | endmask);
            return;
        }
        long[] lArray = this.bits[startWord / 4096];
        int n = startWord % 4096;
        lArray[n] = lArray[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        if (startWord / 4096 == middle / 4096) {
            Arrays.fill(this.bits[startWord / 4096], (startWord + 1) % 4096, middle % 4096, 0L);
        } else {
            while (++startWord < middle) {
                this.bits[startWord / 4096][startWord % 4096] = 0L;
            }
        }
        if (endWord < this.wlen) {
            long[] lArray2 = this.bits[endWord / 4096];
            int n2 = endWord % 4096;
            lArray2[n2] = lArray2[n2] & endmask;
        }
    }

    public void clear(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            long[] lArray = this.bits[startWord / 4096];
            int n = startWord % 4096;
            lArray[n] = lArray[n] & (startmask | endmask);
            return;
        }
        long[] lArray = this.bits[startWord / 4096];
        int n = startWord % 4096;
        lArray[n] = lArray[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        if (startWord / 4096 == middle / 4096) {
            Arrays.fill(this.bits[startWord / 4096], (startWord + 1) % 4096, middle % 4096, 0L);
        } else {
            while (++startWord < middle) {
                this.bits[startWord / 4096][startWord % 4096] = 0L;
            }
        }
        if (endWord < this.wlen) {
            long[] lArray2 = this.bits[endWord / 4096];
            int n2 = endWord % 4096;
            lArray2[n2] = lArray2[n2] & endmask;
        }
    }

    public long cardinality() {
        long bitCount = 0L;
        int i = this.getPageCount();
        while (i-- > 0) {
            bitCount += BitUtil.pop_array(this.bits[i], 0, this.wlen);
        }
        return bitCount;
    }

    public void intersect(OpenBitSet other) {
        int newLen = Math.min(this.wlen, other.wlen);
        long[][] thisArr = this.bits;
        long[][] otherArr = other.bits;
        int thisPageSize = 4096;
        int otherPageSize = 4096;
        int pos = newLen;
        while (--pos >= 0) {
            long[] lArray = thisArr[pos / thisPageSize];
            int n = pos % thisPageSize;
            lArray[n] = lArray[n] & otherArr[pos / otherPageSize][pos % otherPageSize];
        }
        if (this.wlen > newLen) {
            pos = this.wlen;
            while (pos-- > newLen) {
                thisArr[pos / thisPageSize][pos % thisPageSize] = 0L;
            }
        }
        this.wlen = newLen;
    }

    public void and(OpenBitSet other) {
        this.intersect(other);
    }

    public void trimTrailingZeros() {
        int idx;
        for (idx = this.wlen - 1; idx >= 0 && this.bits[idx / 4096][idx % 4096] == 0L; --idx) {
        }
        this.wlen = idx + 1;
    }

    public static long bits2words(long numBits) {
        return (numBits - 1L >>> 6) + 1L;
    }

    public boolean equals(Object o) {
        int i;
        OpenBitSet a;
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenBitSet)) {
            return false;
        }
        OpenBitSet b = (OpenBitSet)o;
        if (b.wlen > this.wlen) {
            a = b;
            b = this;
        } else {
            a = this;
        }
        int aPageSize = 4096;
        int bPageSize = 4096;
        for (i = a.wlen - 1; i >= b.wlen; --i) {
            if (a.bits[i / aPageSize][i % aPageSize] == 0L) continue;
            return false;
        }
        for (i = b.wlen - 1; i >= 0; --i) {
            if (a.bits[i / aPageSize][i % aPageSize] == b.bits[i / bPageSize][i % bPageSize]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long h = 0L;
        int i = this.wlen;
        while (--i >= 0) {
            h ^= this.bits[i / 4096][i % 4096];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void serialize(DataOutput dos) throws IOException {
        int bitLength = this.getNumWords();
        int pageSize = this.getPageSize();
        int pageCount = this.getPageCount();
        dos.writeInt(bitLength);
        for (int p = 0; p < pageCount; ++p) {
            long[] bits = this.getPage(p);
            for (int i = 0; i < pageSize && bitLength-- > 0; ++i) {
                dos.writeLong(bits[i]);
            }
        }
    }

    @Override
    public long serializedSize(TypeSizes type) {
        int bitLength = this.getNumWords();
        int pageSize = this.getPageSize();
        int pageCount = this.getPageCount();
        long size = type.sizeof(bitLength);
        for (int p = 0; p < pageCount; ++p) {
            long[] bits = this.getPage(p);
            for (int i = 0; i < pageSize && bitLength-- > 0; ++i) {
                size += (long)type.sizeof(bits[i]);
            }
        }
        return size;
    }

    @Override
    public void clear() {
        this.clear(0L, this.capacity());
    }

    public static OpenBitSet deserialize(DataInput dis) throws IOException {
        long bitLength = dis.readInt();
        OpenBitSet bs = new OpenBitSet(bitLength << 6);
        int pageSize = bs.getPageSize();
        int pageCount = bs.getPageCount();
        for (int p = 0; p < pageCount; ++p) {
            long[] bits = bs.getPage(p);
            for (int i = 0; i < pageSize && bitLength-- > 0L; ++i) {
                bits[i] = dis.readLong();
            }
        }
        return bs;
    }
}

