/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

class ConjunctionScorer
extends Scorer {
    final ConjunctionDISI disi;
    final Scorer[] scorers;
    final float coord;

    ConjunctionScorer(Weight weight, List<? extends DocIdSetIterator> required, List<Scorer> scorers) {
        this(weight, required, scorers, 1.0f);
    }

    ConjunctionScorer(Weight weight, List<? extends DocIdSetIterator> required, List<Scorer> scorers, float coord) {
        super(weight);
        assert (required.containsAll(scorers));
        this.coord = coord;
        this.disi = ConjunctionDISI.intersect(required);
        this.scorers = scorers.toArray(new Scorer[scorers.size()]);
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        return this.disi.asTwoPhaseIterator();
    }

    @Override
    public int advance(int target) throws IOException {
        return this.disi.advance(target);
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.disi.nextDoc();
    }

    @Override
    public float score() throws IOException {
        double sum = 0.0;
        for (Scorer scorer : this.scorers) {
            sum += (double)scorer.score();
        }
        return this.coord * (float)sum;
    }

    @Override
    public int freq() {
        return this.scorers.length;
    }

    @Override
    public long cost() {
        return this.disi.cost();
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() {
        ArrayList<Scorer.ChildScorer> children = new ArrayList<Scorer.ChildScorer>();
        for (Scorer scorer : this.scorers) {
            children.add(new Scorer.ChildScorer(scorer, "MUST"));
        }
        return children;
    }

    static final class DocsAndFreqs {
        final long cost;
        final DocIdSetIterator iterator;
        int doc = -1;

        DocsAndFreqs(DocIdSetIterator iterator) {
            this.iterator = iterator;
            this.cost = iterator.cost();
        }
    }
}

