/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.ByteSizeValue;

public class StoreRateLimiting {
    private final RateLimiter.SimpleRateLimiter rateLimiter = new RateLimiter.SimpleRateLimiter(0.0);
    private volatile RateLimiter.SimpleRateLimiter actualRateLimiter;
    private volatile Type type;

    @Nullable
    public RateLimiter getRateLimiter() {
        return this.actualRateLimiter;
    }

    public void setMaxRate(ByteSizeValue rate) {
        if (rate.bytes() <= 0L) {
            this.actualRateLimiter = null;
        } else if (this.actualRateLimiter == null) {
            this.actualRateLimiter = this.rateLimiter;
            this.actualRateLimiter.setMBPerSec(rate.mbFrac());
        } else {
            assert (this.rateLimiter == this.actualRateLimiter);
            this.rateLimiter.setMBPerSec(rate.mbFrac());
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = Type.fromString(type);
    }

    public static enum Type {
        NONE,
        MERGE,
        ALL;


        public static Type fromString(String type) {
            if ("none".equalsIgnoreCase(type)) {
                return NONE;
            }
            if ("merge".equalsIgnoreCase(type)) {
                return MERGE;
            }
            if ("all".equalsIgnoreCase(type)) {
                return ALL;
            }
            throw new IllegalArgumentException("rate limiting type [" + type + "] not valid, can be one of [all|merge|none]");
        }
    }

    public static interface Listener {
        public void onPause(long var1);
    }

    public static interface Provider {
        public StoreRateLimiting rateLimiting();
    }
}

